/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.io_stream;

import cool.scx.bytes.ByteReader;
import cool.scx.bytes.supplier.ByteSupplier;
import cool.scx.io.io_stream.CheckedInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ByteReaderInputStream
extends CheckedInputStream {
    private final ByteReader dataReader;

    public ByteReaderInputStream(ByteReader dataReader) {
        this.dataReader = dataReader;
    }

    public ByteReaderInputStream(ByteSupplier dataSupplier) {
        this.dataReader = new ByteReader(dataSupplier);
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamRead();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamRead(b, off, len);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamTransferTo(out);
    }

    public ByteReader dataReader() {
        return this.dataReader;
    }

    @Override
    public void mark(int readlimit) {
        this.dataReader.mark();
    }

    @Override
    public void reset() throws IOException {
        this.dataReader.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.dataReader.inputStreamReadNBytes((long)len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.dataReader.inputStreamReadNBytes(Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

