/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.indexer;

import cool.scx.io.ByteChunk;
import cool.scx.io.indexer.ByteIndexer;

public final class KMPByteIndexer
implements ByteIndexer {
    private final byte[] pattern;
    private final int[] lps;
    private int matchedLength;

    public KMPByteIndexer(byte[] pattern) {
        this.pattern = pattern;
        this.lps = KMPByteIndexer.buildLPS(pattern);
        this.matchedLength = 0;
    }

    public static int[] buildLPS(byte[] pattern) {
        int[] lps = new int[pattern.length];
        int length = 0;
        int i = 1;
        while (i < pattern.length) {
            if (pattern[i] == pattern[length]) {
                lps[i] = ++length;
                ++i;
                continue;
            }
            if (length != 0) {
                length = lps[length - 1];
                continue;
            }
            lps[i] = 0;
            ++i;
        }
        return lps;
    }

    @Override
    public int indexOf(ByteChunk chunk) {
        if (this.isEmptyPattern()) {
            return 0;
        }
        for (int i = 0; i < chunk.length; ++i) {
            byte currentByte = chunk.getByte(i);
            while (this.matchedLength > 0 && currentByte != this.pattern[this.matchedLength]) {
                this.matchedLength = this.lps[this.matchedLength - 1];
            }
            if (currentByte == this.pattern[this.matchedLength]) {
                ++this.matchedLength;
            }
            if (this.matchedLength != this.pattern.length) continue;
            int result = i - this.matchedLength + 1;
            this.matchedLength = 0;
            return result;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isEmptyPattern() {
        return this.pattern.length == 0;
    }

    public byte[] pattern() {
        return this.pattern;
    }

    public int matchedLength() {
        return this.matchedLength;
    }

    public void reset() {
        this.matchedLength = 0;
    }
}

