/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.consumer.ByteChunkByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.supplier.ByteSupplier;

public class FixedLengthByteSupplier
implements ByteSupplier {
    private final ByteInput byteInput;
    private final ByteChunkByteConsumer consumer;
    private final boolean autoClose;
    private long remaining;

    public FixedLengthByteSupplier(ByteInput byteInput, long maxLength) {
        this(byteInput, maxLength, false);
    }

    public FixedLengthByteSupplier(ByteInput byteInput, long maxLength, boolean autoClose) {
        this.byteInput = byteInput;
        this.consumer = new ByteChunkByteConsumer();
        this.remaining = maxLength;
        this.autoClose = autoClose;
    }

    @Override
    public ByteChunk get() throws AlreadyClosedException, ScxIOException {
        if (this.remaining <= 0L) {
            return null;
        }
        try {
            this.byteInput.read(this.consumer, this.remaining);
            ByteChunk byteChunk = this.consumer.byteChunk();
            this.remaining -= (long)byteChunk.length;
            return byteChunk;
        }
        catch (NoMoreDataException e) {
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.autoClose) {
            this.byteInput.close();
        }
    }
}

