/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.consumer.ByteArrayByteConsumer;
import cool.scx.io.consumer.ByteConsumer;
import cool.scx.io.consumer.SkipByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.indexer.KMPByteIndexer;
import cool.scx.io.indexer.SingleByteIndexer;

public interface ByteInput
extends AutoCloseable {
    public byte read() throws ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void read(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void readUpTo(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void readFully(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public byte peek() throws ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void peek(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void peekUpTo(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void peekFully(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public long indexOf(ByteIndexer var1, long var2) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public void mark() throws AlreadyClosedException;

    public void reset() throws AlreadyClosedException;

    public boolean isClosed();

    @Override
    public void close() throws ScxIOException;

    default public byte[] read(int maxLength) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.read(consumer, maxLength);
        return consumer.bytes();
    }

    default public byte[] readUpTo(int length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.readUpTo(consumer, length);
        return consumer.bytes();
    }

    default public byte[] readFully(int length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.readFully(consumer, length);
        return consumer.bytes();
    }

    default public byte[] readAll() throws ScxIOException, AlreadyClosedException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.readAll(consumer);
        return consumer.bytes();
    }

    default public <X extends Throwable> void readAll(ByteConsumer<X> byteConsumer) throws X, ScxIOException, AlreadyClosedException {
        try {
            this.readUpTo(byteConsumer, Long.MAX_VALUE);
        }
        catch (NoMoreDataException noMoreDataException) {
            // empty catch block
        }
    }

    default public byte[] peek(int maxLength) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peek(consumer, maxLength);
        return consumer.bytes();
    }

    default public byte[] peekUpTo(int length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peekUpTo(consumer, length);
        return consumer.bytes();
    }

    default public byte[] peekFully(int length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peekFully(consumer, length);
        return consumer.bytes();
    }

    default public byte[] peekAll() throws ScxIOException, AlreadyClosedException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peekAll(consumer);
        return consumer.bytes();
    }

    default public <X extends Throwable> void peekAll(ByteConsumer<X> byteConsumer) throws X, ScxIOException, AlreadyClosedException {
        try {
            this.peekUpTo(byteConsumer, Long.MAX_VALUE);
        }
        catch (NoMoreDataException noMoreDataException) {
            // empty catch block
        }
    }

    default public long skip(long length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        SkipByteConsumer consumer = new SkipByteConsumer();
        this.read(consumer, length);
        return consumer.bytesSkipped();
    }

    default public long skipUpTo(long length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        SkipByteConsumer consumer = new SkipByteConsumer();
        this.readUpTo(consumer, length);
        return consumer.bytesSkipped();
    }

    default public long skipFully(long length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        SkipByteConsumer consumer = new SkipByteConsumer();
        this.readFully(consumer, length);
        return consumer.bytesSkipped();
    }

    default public long skipAll() throws ScxIOException, AlreadyClosedException {
        SkipByteConsumer consumer = new SkipByteConsumer();
        this.readAll(consumer);
        return consumer.bytesSkipped();
    }

    default public long indexOf(byte b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public long indexOf(byte b, long maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(new SingleByteIndexer(b), maxLength);
    }

    default public long indexOf(byte[] b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public long indexOf(byte[] b, long maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(new KMPByteIndexer(b), maxLength);
    }

    default public byte[] readUntil(byte b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.readUntil(b, Integer.MAX_VALUE);
    }

    default public byte[] readUntil(byte b, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        byte[] bytes = this.readFully((int)index);
        this.skipFully(1L);
        return bytes;
    }

    default public byte[] readUntil(byte[] b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.readUntil(b, Integer.MAX_VALUE);
    }

    default public byte[] readUntil(byte[] b, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        byte[] bytes = this.readFully((int)index);
        this.skipFully(b.length);
        return bytes;
    }

    default public byte[] peekUntil(byte b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.peekUntil(b, Integer.MAX_VALUE);
    }

    default public byte[] peekUntil(byte b, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        return this.peekFully((int)index);
    }

    default public byte[] peekUntil(byte[] b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.peekUntil(b, Integer.MAX_VALUE);
    }

    default public byte[] peekUntil(byte[] b, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        return this.peekFully((int)index);
    }
}

