/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteInput;
import cool.scx.io.consumer.ByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.ByteIndexer;

public class NullByteInput
implements ByteInput {
    private volatile boolean closed = false;

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
    }

    @Override
    public byte read() throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        throw new NoMoreDataException();
    }

    @Override
    public <X extends Throwable> void read(ByteConsumer<X> byteConsumer, long maxLength) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (maxLength > 0L) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public <X extends Throwable> void readUpTo(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public <X extends Throwable> void readFully(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public byte peek() throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        throw new NoMoreDataException();
    }

    @Override
    public <X extends Throwable> void peek(ByteConsumer<X> byteConsumer, long maxLength) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (maxLength > 0L) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public <X extends Throwable> void peekUpTo(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public <X extends Throwable> void peekFully(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public long indexOf(ByteIndexer indexer, long maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (indexer.isEmptyPattern()) {
            return 0L;
        }
        if (maxLength > 0L) {
            throw new NoMoreDataException();
        }
        throw new NoMatchFoundException();
    }

    @Override
    public void mark() throws AlreadyClosedException {
        this.ensureOpen();
    }

    @Override
    public void reset() throws AlreadyClosedException {
        this.ensureOpen();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws ScxIOException {
        this.closed = true;
    }
}

