/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.adapter;

import cool.scx.io.ByteInput;
import cool.scx.io.adapter.ByteInputAdapter;
import cool.scx.io.consumer.FillByteArrayByteConsumer;
import cool.scx.io.consumer.OutputStreamByteConsumer;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteInputInputStream
extends InputStream
implements ByteInputAdapter {
    private final ByteInput byteInput;

    public ByteInputInputStream(ByteInput byteInput) {
        this.byteInput = byteInput;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.byteInput.read() & 0xFF;
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
        catch (NoMoreDataException e) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        FillByteArrayByteConsumer consumer = new FillByteArrayByteConsumer(b, off, len);
        try {
            this.byteInput.read(consumer, len);
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
        catch (NoMoreDataException e) {
            return -1;
        }
        return consumer.bytesFilled();
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        FillByteArrayByteConsumer consumer = new FillByteArrayByteConsumer(b, off, len);
        try {
            this.byteInput.readUpTo(consumer, len);
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
        catch (NoMoreDataException e) {
            return 0;
        }
        return consumer.bytesFilled();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        try {
            return this.byteInput.readUpTo(len);
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
        catch (NoMoreDataException e) {
            return new byte[0];
        }
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        try {
            return this.byteInput.readAll();
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.byteInput.skip(n);
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
        catch (NoMoreDataException e) {
            return 0L;
        }
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        try {
            this.byteInput.skipFully(n);
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
        catch (NoMoreDataException e) {
            throw new EOFException();
        }
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        OutputStreamByteConsumer consumer = new OutputStreamByteConsumer(out);
        try {
            this.byteInput.readAll(consumer);
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
        return consumer.bytesWritten();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.byteInput.mark();
    }

    @Override
    public void reset() throws IOException {
        this.byteInput.reset();
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
        try {
            this.byteInput.close();
        }
        catch (ScxIOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                IOException ioException = (IOException)cause;
                throw ioException;
            }
            throw e;
        }
    }

    @Override
    public ByteInput byteInput() {
        return this.byteInput;
    }
}

