/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.KMPByteIndexer;
import cool.scx.io.supplier.ByteSupplier;
import java.util.Arrays;

public final class BoundaryByteSupplier
implements ByteSupplier {
    private final ByteInput byteInput;
    private final KMPByteIndexer byteIndexer;
    private final int bufferLength;
    private final boolean autoClose;
    private boolean isFinish;

    public BoundaryByteSupplier(ByteInput byteInput, byte[] boundaryBytes) {
        this(byteInput, boundaryBytes, 8192, false);
    }

    public BoundaryByteSupplier(ByteInput byteInput, byte[] boundaryBytes, boolean autoClose) {
        this(byteInput, boundaryBytes, 8192, autoClose);
    }

    public BoundaryByteSupplier(ByteInput byteInput, byte[] boundaryBytes, int bufferLength) {
        this(byteInput, boundaryBytes, bufferLength, false);
    }

    public BoundaryByteSupplier(ByteInput byteInput, byte[] boundaryBytes, int bufferLength, boolean autoClose) {
        this.byteInput = byteInput;
        this.byteIndexer = new KMPByteIndexer(boundaryBytes);
        this.bufferLength = bufferLength;
        this.autoClose = autoClose;
        this.isFinish = false;
    }

    @Override
    public ByteChunk get() throws AlreadyClosedException, ScxIOException {
        if (this.isFinish) {
            return null;
        }
        try {
            long index = this.byteInput.indexOf(this.byteIndexer, (long)this.bufferLength);
            byte[] read = this.byteInput.readFully((int)index);
            this.isFinish = true;
            return new ByteChunk(read);
        }
        catch (NoMatchFoundException e) {
            if (this.byteIndexer.matchedLength() == 0) {
                byte[] read = this.byteInput.readFully(this.bufferLength);
                return new ByteChunk(read);
            }
            byte[] peek = this.byteInput.peekFully(this.byteIndexer.pattern().length);
            boolean match = Arrays.equals(peek, this.byteIndexer.pattern());
            if (match) {
                this.isFinish = true;
                return null;
            }
            this.byteInput.skipFully(this.byteIndexer.pattern().length);
            return new ByteChunk(peek);
        }
        catch (NoMoreDataException e) {
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.autoClose) {
            this.byteInput.close();
        }
    }
}

