/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.supplier.ByteSupplier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class SequenceByteSupplier
implements ByteSupplier {
    private final Collection<ByteSupplier> dataSupplierList;
    private final boolean closeOnSwitch;
    private final Iterator<ByteSupplier> iterator;
    private ByteSupplier currentSupplier;

    public SequenceByteSupplier(ByteSupplier ... suppliers) {
        this(List.of(suppliers), true);
    }

    public SequenceByteSupplier(Collection<ByteSupplier> dataSupplierList, boolean closeOnSwitch) {
        this.dataSupplierList = dataSupplierList;
        this.closeOnSwitch = closeOnSwitch;
        this.iterator = this.dataSupplierList.iterator();
        if (this.iterator.hasNext()) {
            this.currentSupplier = this.iterator.next();
        }
    }

    @Override
    public ByteChunk get() throws Exception {
        while (this.currentSupplier != null) {
            ByteChunk dataNode = this.currentSupplier.get();
            if (dataNode != null) {
                return dataNode;
            }
            if (this.closeOnSwitch) {
                this.currentSupplier.close();
            }
            if (this.iterator.hasNext()) {
                this.currentSupplier = this.iterator.next();
                continue;
            }
            this.currentSupplier = null;
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        Exception ex = null;
        if (this.closeOnSwitch) {
            while (this.currentSupplier != null) {
                try {
                    this.currentSupplier.close();
                }
                catch (Exception e) {
                    if (ex == null) {
                        ex = e;
                    }
                    ex.addSuppressed(e);
                }
                if (this.iterator.hasNext()) {
                    this.currentSupplier = this.iterator.next();
                    continue;
                }
                this.currentSupplier = null;
            }
        } else {
            for (ByteSupplier byteSupplier : this.dataSupplierList) {
                try {
                    byteSupplier.close();
                }
                catch (Exception e) {
                    if (ex == null) {
                        ex = e;
                        continue;
                    }
                    ex.addSuppressed(e);
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

