/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.consumer.ByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.supplier.ByteSupplier;

public class DefaultByteInput
implements ByteInput {
    private final ByteSupplier byteSupplier;
    private ByteChunkNode head;
    private ByteChunkNode tail;
    private ByteChunkNode markNode;
    private int markPosition;
    private volatile boolean closed;

    public DefaultByteInput(ByteSupplier byteSupplier) {
        this.byteSupplier = byteSupplier;
        this.tail = this.head = new ByteChunkNode(ByteChunk.EMPTY_CHUNK);
        this.markNode = null;
        this.markPosition = 0;
    }

    private void appendByteChunk(ByteChunk byteChunk) {
        this.tail = this.tail.next = new ByteChunkNode(byteChunk);
    }

    private boolean pullByteChunk() throws ScxIOException {
        ByteChunk byteChunk;
        do {
            try {
                byteChunk = this.byteSupplier.get();
            }
            catch (ScxIOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ScxIOException(e);
            }
            if (byteChunk != null) continue;
            return true;
        } while (byteChunk.length == 0);
        this.appendByteChunk(byteChunk);
        return false;
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
    }

    private long ensureAvailable() throws ScxIOException, NoMoreDataException {
        long pullCount = 0L;
        if (this.head.hasAvailable()) {
            return pullCount;
        }
        if (this.head.next == null) {
            boolean eof = this.pullByteChunk();
            if (eof) {
                throw new NoMoreDataException();
            }
            ++pullCount;
        }
        this.head = this.head.next;
        return pullCount;
    }

    private <X extends Throwable> void read0(ByteConsumer<X> consumer, long maxLength, boolean movePointer, long maxPullCount, boolean throwOnEOF) throws X, ScxIOException, NoMoreDataException {
        long remaining = maxLength;
        ByteChunkNode n = this.head;
        long pullCount = 0L;
        while (remaining > 0L) {
            int length = (int)Math.min(remaining, (long)n.available());
            boolean needMore = consumer.accept(n.chunk.subChunk(n.position, n.position + length));
            remaining -= (long)length;
            if (movePointer) {
                n.position += length;
            }
            if (remaining <= 0L || !needMore) break;
            if (n.next == null) {
                if (pullCount >= maxPullCount) break;
                boolean eof = this.pullByteChunk();
                if (eof) {
                    if (!throwOnEOF) break;
                    throw new NoMoreDataException();
                }
                ++pullCount;
            }
            n = n.next;
            if (!movePointer) continue;
            this.head = n;
        }
    }

    private long indexOf0(ByteIndexer indexer, long maxLength, long maxPullCount) throws NoMatchFoundException, ScxIOException {
        long index = 0L;
        ByteChunkNode n = this.head;
        long pullCount = 0L;
        while (index < maxLength) {
            int length = (int)Math.min((long)n.available(), maxLength - index);
            int i = indexer.indexOf(n.chunk.subChunk(n.position, n.position + length));
            if (i != Integer.MIN_VALUE) {
                return index + (long)i;
            }
            if ((index += (long)length) >= maxLength) break;
            if (n.next == null) {
                boolean eof;
                if (pullCount >= maxPullCount || (eof = this.pullByteChunk())) break;
                ++pullCount;
            }
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public byte read() throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        this.ensureAvailable();
        byte b = this.head.chunk.getByte(this.head.position);
        ++this.head.position;
        return b;
    }

    @Override
    public <X extends Throwable> void read(ByteConsumer<X> byteConsumer, long maxLength) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        long pulledCount = 0L;
        if (maxLength > 0L) {
            pulledCount = this.ensureAvailable();
        }
        this.read0(byteConsumer, maxLength, true, 1L - pulledCount, false);
    }

    @Override
    public <X extends Throwable> void readUpTo(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            this.ensureAvailable();
        }
        this.read0(byteConsumer, length, true, Long.MAX_VALUE, false);
    }

    @Override
    public <X extends Throwable> void readFully(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            this.ensureAvailable();
        }
        this.read0(byteConsumer, length, true, Long.MAX_VALUE, true);
    }

    @Override
    public byte peek() throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        this.ensureAvailable();
        return this.head.chunk.getByte(this.head.position);
    }

    @Override
    public <X extends Throwable> void peek(ByteConsumer<X> byteConsumer, long maxLength) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        long pulledCount = 0L;
        if (maxLength > 0L) {
            pulledCount = this.ensureAvailable();
        }
        this.read0(byteConsumer, maxLength, false, 1L - pulledCount, false);
    }

    @Override
    public <X extends Throwable> void peekUpTo(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            this.ensureAvailable();
        }
        this.read0(byteConsumer, length, false, Long.MAX_VALUE, false);
    }

    @Override
    public <X extends Throwable> void peekFully(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            this.ensureAvailable();
        }
        this.read0(byteConsumer, length, false, Long.MAX_VALUE, true);
    }

    @Override
    public long indexOf(ByteIndexer indexer, long maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (indexer.isEmptyPattern()) {
            return 0L;
        }
        if (maxLength > 0L) {
            this.ensureAvailable();
        }
        return this.indexOf0(indexer, maxLength, Long.MAX_VALUE);
    }

    @Override
    public void mark() throws AlreadyClosedException {
        this.ensureOpen();
        this.markNode = this.head;
        this.markPosition = this.head.position;
    }

    @Override
    public void reset() throws AlreadyClosedException {
        this.ensureOpen();
        if (this.markNode == null) {
            return;
        }
        this.head = this.markNode;
        this.head.position = this.markPosition;
        ByteChunkNode n = this.head.next;
        while (n != null) {
            n.reset();
            n = n.next;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws ScxIOException {
        try {
            this.byteSupplier.close();
        }
        catch (ScxIOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScxIOException(e);
        }
        finally {
            this.closed = true;
        }
    }

    private static class ByteChunkNode {
        public final ByteChunk chunk;
        public int position;
        public ByteChunkNode next;

        public ByteChunkNode(ByteChunk chunk) {
            this.chunk = chunk;
            this.position = 0;
            this.next = null;
        }

        public int available() {
            return this.chunk.length - this.position;
        }

        public boolean hasAvailable() {
            return this.position < this.chunk.length;
        }

        public void reset() {
            this.position = 0;
        }

        public String toString() {
            return this.chunk.toString(this.position);
        }
    }
}

