/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.consumer.ByteChunkByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.KMPByteIndexer;
import cool.scx.io.supplier.ByteSupplier;
import java.util.LinkedList;

public final class BoundaryByteSupplier
implements ByteSupplier {
    private final ByteInput byteInput;
    private final KMPByteIndexer byteIndexer;
    private final boolean autoClose;
    private final ByteChunkByteConsumer consumer;
    private final LinkedList<ByteChunk> cache;
    private boolean useCache;
    private boolean isFinish;

    public BoundaryByteSupplier(ByteInput byteInput, byte[] boundaryBytes) {
        this(byteInput, boundaryBytes, false);
    }

    public BoundaryByteSupplier(ByteInput byteInput, byte[] boundaryBytes, boolean autoClose) {
        this.byteInput = byteInput;
        this.byteIndexer = new KMPByteIndexer(boundaryBytes);
        this.autoClose = autoClose;
        this.consumer = new ByteChunkByteConsumer();
        this.cache = new LinkedList();
        this.useCache = false;
        this.isFinish = this.byteIndexer.isEmptyPattern();
    }

    @Override
    public ByteChunk get() throws AlreadyClosedException, ScxIOException, NoMoreDataException {
        if (this.useCache) {
            ByteChunk cacheChunk = this.cache.pollFirst();
            if (cacheChunk != null) {
                return cacheChunk;
            }
            this.useCache = false;
        }
        if (this.isFinish) {
            return null;
        }
        try {
            this.byteInput.peek(this.consumer, Long.MAX_VALUE);
        }
        catch (NoMoreDataException e) {
            this.isFinish = true;
            return null;
        }
        ByteChunk byteChunk = this.consumer.byteChunk();
        int i = this.byteIndexer.indexOf(byteChunk);
        if (i != Integer.MIN_VALUE) {
            int safeLength = i + this.byteIndexer.pattern().length;
            this.byteInput.skipFully(safeLength);
            this.isFinish = true;
            if (this.cache.isEmpty()) {
                return byteChunk.subChunk(0, i);
            }
            this.cache.addLast(byteChunk.subChunk(0, safeLength));
            this.trimTailBytes(this.byteIndexer.pattern().length);
            this.useCache = true;
            return ByteChunk.EMPTY_CHUNK;
        }
        if (this.byteIndexer.matchedLength() == 0) {
            this.byteInput.skipFully(byteChunk.length);
            if (this.cache.isEmpty()) {
                return byteChunk;
            }
            this.cache.addLast(byteChunk);
            this.useCache = true;
            return ByteChunk.EMPTY_CHUNK;
        }
        this.byteInput.skipFully(byteChunk.length);
        this.cache.addLast(byteChunk);
        this.useCache = false;
        return ByteChunk.EMPTY_CHUNK;
    }

    private void trimTailBytes(int length) {
        ByteChunk last;
        while (length > 0 && (last = this.cache.pollLast()) != null) {
            if (last.length > length) {
                this.cache.addLast(last.subChunk(0, last.length - length));
                length = 0;
                continue;
            }
            length -= last.length;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.autoClose) {
            this.byteInput.close();
        }
    }
}

