/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.supplier.ByteSupplier;
import java.io.IOException;
import java.io.InputStream;

public final class BufferedInputStreamByteSupplier
implements ByteSupplier {
    private final InputStream inputStream;
    private final byte[] buffer;

    public BufferedInputStreamByteSupplier(InputStream inputStream, int bufferLength) {
        this.inputStream = inputStream;
        this.buffer = new byte[bufferLength];
    }

    public BufferedInputStreamByteSupplier(InputStream inputStream) {
        this(inputStream, 8192);
    }

    @Override
    public ByteChunk get() throws IOException {
        int i = this.inputStream.read(this.buffer);
        if (i == -1) {
            return null;
        }
        byte[] data = new byte[i];
        System.arraycopy(this.buffer, 0, data, 0, i);
        return new ByteChunk(data);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

