/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.ByteInputMark;
import cool.scx.io.ByteMatchResult;
import cool.scx.io.consumer.ByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.indexer.StatusByteMatchResult;
import cool.scx.io.supplier.ByteSupplier;

public class DefaultByteInput
implements ByteInput {
    protected final ByteSupplier byteSupplier;
    protected ByteChunkNode head;
    protected ByteChunkNode tail;
    protected volatile boolean closed;

    public DefaultByteInput(ByteSupplier byteSupplier) {
        this.byteSupplier = byteSupplier;
        this.tail = this.head = new ByteChunkNode(ByteChunk.EMPTY_BYTE_CHUNK);
        this.closed = false;
    }

    protected void appendByteChunk(ByteChunk byteChunk) {
        this.tail = this.tail.next = new ByteChunkNode(byteChunk);
    }

    protected boolean pullByteChunk() throws ScxIOException {
        ByteChunk byteChunk;
        do {
            try {
                byteChunk = this.byteSupplier.get();
            }
            catch (ScxIOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ScxIOException(e);
            }
            if (byteChunk != null) continue;
            return true;
        } while (byteChunk.length == 0);
        this.appendByteChunk(byteChunk);
        return false;
    }

    protected void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
    }

    protected long ensureAvailable() throws ScxIOException, NoMoreDataException {
        long pullCount = 0L;
        if (this.head.hasAvailable()) {
            return pullCount;
        }
        if (this.head.next == null) {
            boolean eof = this.pullByteChunk();
            if (eof) {
                throw new NoMoreDataException();
            }
            ++pullCount;
        }
        this.head = this.head.next;
        return pullCount;
    }

    protected <X extends Throwable> void read0(ByteConsumer<X> consumer, long maxLength, boolean movePointer, long maxPullCount, boolean throwOnEOF) throws X, ScxIOException, NoMoreDataException {
        long remaining = maxLength;
        ByteChunkNode n = this.head;
        long pullCount = 0L;
        while (remaining > 0L) {
            int length = (int)Math.min(remaining, (long)n.available());
            boolean needMore = consumer.accept(n.chunk.subChunk(n.position, n.position + length));
            remaining -= (long)length;
            if (movePointer) {
                n.position += length;
            }
            if (remaining <= 0L || !needMore) break;
            if (n.next == null) {
                if (pullCount >= maxPullCount) break;
                boolean eof = this.pullByteChunk();
                if (eof) {
                    if (!throwOnEOF) break;
                    throw new NoMoreDataException();
                }
                ++pullCount;
            }
            n = n.next;
            if (!movePointer) continue;
            this.head = n;
        }
    }

    protected ByteMatchResult indexOf0(ByteIndexer indexer, long maxLength, long maxPullCount) throws NoMatchFoundException, ScxIOException {
        long index = 0L;
        ByteChunkNode n = this.head;
        long pullCount = 0L;
        while (index < maxLength) {
            int length = (int)Math.min((long)n.available(), maxLength - index);
            StatusByteMatchResult indexMatchResult = indexer.indexOf(n.chunk.subChunk(n.position, n.position + length));
            if (indexMatchResult.status == StatusByteMatchResult.Status.FULL_MATCH) {
                return new ByteMatchResult(index + (long)indexMatchResult.index, indexMatchResult.matchedLength);
            }
            if ((index += (long)length) >= maxLength) break;
            if (n.next == null) {
                boolean eof;
                if (pullCount >= maxPullCount || (eof = this.pullByteChunk())) break;
                ++pullCount;
            }
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public byte read() throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        this.ensureAvailable();
        byte b = this.head.chunk.getByte(this.head.position);
        ++this.head.position;
        return b;
    }

    @Override
    public <X extends Throwable> void read(ByteConsumer<X> byteConsumer, long maxLength) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        long pulledCount = 0L;
        if (maxLength > 0L) {
            pulledCount = this.ensureAvailable();
        }
        this.read0(byteConsumer, maxLength, true, 1L - pulledCount, false);
    }

    @Override
    public <X extends Throwable> void readUpTo(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            this.ensureAvailable();
        }
        this.read0(byteConsumer, length, true, Long.MAX_VALUE, false);
    }

    @Override
    public <X extends Throwable> void readFully(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            this.ensureAvailable();
        }
        this.read0(byteConsumer, length, true, Long.MAX_VALUE, true);
    }

    @Override
    public byte peek() throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        this.ensureAvailable();
        return this.head.chunk.getByte(this.head.position);
    }

    @Override
    public <X extends Throwable> void peek(ByteConsumer<X> byteConsumer, long maxLength) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        long pulledCount = 0L;
        if (maxLength > 0L) {
            pulledCount = this.ensureAvailable();
        }
        this.read0(byteConsumer, maxLength, false, 1L - pulledCount, false);
    }

    @Override
    public <X extends Throwable> void peekUpTo(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            this.ensureAvailable();
        }
        this.read0(byteConsumer, length, false, Long.MAX_VALUE, false);
    }

    @Override
    public <X extends Throwable> void peekFully(ByteConsumer<X> byteConsumer, long length) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (length > 0L) {
            this.ensureAvailable();
        }
        this.read0(byteConsumer, length, false, Long.MAX_VALUE, true);
    }

    @Override
    public ByteMatchResult indexOf(ByteIndexer indexer, long maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        this.ensureOpen();
        if (indexer.isEmptyPattern()) {
            return new ByteMatchResult(0L, 0);
        }
        if (maxLength > 0L) {
            this.ensureAvailable();
        }
        return this.indexOf0(indexer, maxLength, Long.MAX_VALUE);
    }

    @Override
    public ByteInputMark mark() throws AlreadyClosedException {
        this.ensureOpen();
        return new DefaultByteInputMark(this, this.head, this.head.position);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws ScxIOException {
        try {
            this.byteSupplier.close();
        }
        catch (ScxIOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScxIOException(e);
        }
        finally {
            this.closed = true;
        }
    }

    protected static class ByteChunkNode {
        public final ByteChunk chunk;
        public int position;
        public ByteChunkNode next;

        public ByteChunkNode(ByteChunk chunk) {
            this.chunk = chunk;
            this.position = 0;
            this.next = null;
        }

        public int available() {
            return this.chunk.length - this.position;
        }

        public boolean hasAvailable() {
            return this.position < this.chunk.length;
        }

        public void reset() {
            this.position = 0;
        }

        public String toString() {
            return this.chunk.toString(this.position);
        }
    }

    protected record DefaultByteInputMark(DefaultByteInput defaultByteInput, ByteChunkNode markNode, int markPosition) implements ByteInputMark
    {
        @Override
        public void reset() throws AlreadyClosedException {
            this.defaultByteInput.ensureOpen();
            this.defaultByteInput.head = this.markNode;
            this.defaultByteInput.head.position = this.markPosition;
            ByteChunkNode n = this.defaultByteInput.head.next;
            while (n != null) {
                n.reset();
                n = n.next;
            }
        }
    }
}

