/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.consumer;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteOutput;
import cool.scx.io.consumer.ByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

public final class ByteOutputByteConsumer
implements ByteConsumer<RuntimeException> {
    private final ByteOutput out;
    private long bytesWritten;

    public ByteOutputByteConsumer(ByteOutput out) {
        this.out = out;
        this.bytesWritten = 0L;
    }

    @Override
    public boolean accept(ByteChunk chunk) throws ScxIOException, AlreadyClosedException {
        this.out.write(chunk.bytes, chunk.start, chunk.length);
        this.bytesWritten += (long)chunk.length;
        return true;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }
}

