/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.indexer;

import cool.scx.io.ByteChunk;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.indexer.StatusByteMatchResult;

public final class KMPByteIndexer
implements ByteIndexer {
    private final byte[] pattern;
    private final int[] lps;
    private int matchedLength;

    public KMPByteIndexer(byte[] pattern) {
        this.pattern = pattern;
        this.lps = KMPByteIndexer.buildLPS(pattern);
        this.matchedLength = 0;
    }

    public static int[] buildLPS(byte[] pattern) {
        int[] lps = new int[pattern.length];
        int length = 0;
        int i = 1;
        while (i < pattern.length) {
            if (pattern[i] == pattern[length]) {
                lps[i] = ++length;
                ++i;
                continue;
            }
            if (length != 0) {
                length = lps[length - 1];
                continue;
            }
            lps[i] = 0;
            ++i;
        }
        return lps;
    }

    @Override
    public StatusByteMatchResult indexOf(ByteChunk chunk) {
        for (int i = 0; i < chunk.length; ++i) {
            byte currentByte = chunk.getByte(i);
            while (this.matchedLength > 0 && currentByte != this.pattern[this.matchedLength]) {
                this.matchedLength = this.lps[this.matchedLength - 1];
            }
            if (currentByte == this.pattern[this.matchedLength]) {
                ++this.matchedLength;
            }
            if (this.matchedLength != this.pattern.length) continue;
            this.matchedLength = 0;
            return StatusByteMatchResult.fullMatch(i - (this.pattern.length - 1), this.pattern.length);
        }
        return this.matchedLength == 0 ? StatusByteMatchResult.NO_MATCH_RESULT : StatusByteMatchResult.PARTIAL_MATCH_RESULT;
    }

    @Override
    public boolean isEmptyPattern() {
        return this.pattern.length == 0;
    }

    @Override
    public void reset() {
        this.matchedLength = 0;
    }
}

