/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.indexer;

import cool.scx.io.ByteChunk;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.indexer.StatusByteMatchResult;

public final class LineBreakByteIndexer
implements ByteIndexer {
    private int matchedLength = 0;

    @Override
    public StatusByteMatchResult indexOf(ByteChunk chunk) {
        for (int i = 0; i < chunk.length; ++i) {
            byte currentByte = chunk.getByte(i);
            if (this.matchedLength == 0) {
                if (currentByte == 10) {
                    this.matchedLength = 0;
                    return StatusByteMatchResult.fullMatch(i, 1);
                }
                if (currentByte == 13) {
                    this.matchedLength = 1;
                    continue;
                }
                this.matchedLength = 0;
                continue;
            }
            if (this.matchedLength != 1) continue;
            if (currentByte == 10) {
                this.matchedLength = 0;
                return StatusByteMatchResult.fullMatch(i - 1, 2);
            }
            this.matchedLength = currentByte == 13 ? 1 : 0;
        }
        return this.matchedLength == 0 ? StatusByteMatchResult.NO_MATCH_RESULT : StatusByteMatchResult.PARTIAL_MATCH_RESULT;
    }

    @Override
    public boolean isEmptyPattern() {
        return false;
    }

    @Override
    public void reset() {
        this.matchedLength = 0;
    }
}

