/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.ByteInputMark;
import cool.scx.io.consumer.ByteChunkByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.indexer.StatusByteMatchResult;
import cool.scx.io.supplier.ByteSupplier;
import java.util.LinkedList;

public final class BoundaryByteSupplier
implements ByteSupplier {
    private final ByteInput byteInput;
    private final ByteIndexer byteIndexer;
    private final boolean keepBoundaryInSource;
    private final ByteChunkByteConsumer consumer;
    private final LinkedList<ByteChunk> cache;
    private boolean useCache;
    private boolean isFinish;
    private ByteInputMark mark;

    public BoundaryByteSupplier(ByteInput byteInput, ByteIndexer byteIndexer, boolean keepBoundaryInSource) {
        this.byteInput = byteInput;
        this.byteIndexer = byteIndexer;
        this.keepBoundaryInSource = keepBoundaryInSource;
        this.consumer = new ByteChunkByteConsumer();
        this.cache = new LinkedList();
        this.useCache = false;
        this.isFinish = this.byteIndexer.isEmptyPattern();
        this.mark = null;
    }

    @Override
    public ByteChunk get() throws AlreadyClosedException, ScxIOException, NoMoreDataException {
        if (this.useCache) {
            ByteChunk cacheChunk = this.cache.pollFirst();
            if (cacheChunk != null) {
                return cacheChunk;
            }
            this.useCache = false;
        }
        if (this.isFinish) {
            return null;
        }
        if (this.keepBoundaryInSource && this.cache.isEmpty()) {
            this.mark = this.byteInput.mark();
        }
        try {
            this.byteInput.peek(this.consumer, Long.MAX_VALUE);
        }
        catch (NoMoreDataException e) {
            this.isFinish = true;
            if (this.cache.isEmpty()) {
                return null;
            }
            this.useCache = true;
            return this.cache.pollFirst();
        }
        ByteChunk byteChunk = this.consumer.byteChunk();
        StatusByteMatchResult indexMatchResult = this.byteIndexer.indexOf(byteChunk);
        if (indexMatchResult.status == StatusByteMatchResult.Status.FULL_MATCH) {
            int safeLength;
            int matchedLength = indexMatchResult.matchedLength;
            int sourceSkipLength = safeLength = indexMatchResult.index + matchedLength;
            if (this.keepBoundaryInSource) {
                if (this.mark != null) {
                    this.mark.reset();
                }
                int cacheLength = 0;
                for (ByteChunk chunk : this.cache) {
                    cacheLength += chunk.length;
                }
                sourceSkipLength = cacheLength + indexMatchResult.index;
            }
            this.byteInput.skipFully(sourceSkipLength);
            this.isFinish = true;
            if (this.cache.isEmpty()) {
                return byteChunk.subChunk(0, indexMatchResult.index);
            }
            this.cache.addLast(byteChunk.subChunk(0, safeLength));
            this.trimTailBytes(matchedLength);
            this.useCache = true;
            return this.cache.pollFirst();
        }
        if (indexMatchResult.status == StatusByteMatchResult.Status.NO_MATCH) {
            this.byteInput.skipFully(byteChunk.length);
            if (this.cache.isEmpty()) {
                return byteChunk;
            }
            this.cache.addLast(byteChunk);
            this.useCache = true;
            return this.cache.pollFirst();
        }
        this.byteInput.skipFully(byteChunk.length);
        this.cache.addLast(byteChunk);
        this.useCache = false;
        return ByteChunk.EMPTY_BYTE_CHUNK;
    }

    private void trimTailBytes(int length) {
        ByteChunk last;
        while (length > 0 && (last = this.cache.pollLast()) != null) {
            if (last.length > length) {
                this.cache.addLast(last.subChunk(0, last.length - length));
                length = 0;
                continue;
            }
            length -= last.length;
        }
    }

    @Override
    public void close() throws ScxIOException {
        this.byteInput.close();
    }
}

