/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.consumer.ByteChunkByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.supplier.ByteSupplier;
import java.util.ArrayList;
import java.util.List;

public final class CacheByteSupplier
implements ByteSupplier {
    private final ByteInput byteInput;
    private final ByteChunkByteConsumer consumer;
    private final List<ByteChunk> cache;
    private int chunkIndex;
    private boolean isFinish;

    public CacheByteSupplier(ByteInput byteInput) {
        this.byteInput = byteInput;
        this.consumer = new ByteChunkByteConsumer();
        this.cache = new ArrayList<ByteChunk>();
        this.chunkIndex = 0;
        this.isFinish = false;
    }

    @Override
    public ByteChunk get() throws AlreadyClosedException, ScxIOException {
        if (this.chunkIndex < this.cache.size()) {
            ByteChunk chunk = this.cache.get(this.chunkIndex);
            ++this.chunkIndex;
            return chunk;
        }
        if (this.isFinish) {
            return null;
        }
        try {
            this.byteInput.read(this.consumer, Long.MAX_VALUE);
            ByteChunk chunk = this.consumer.byteChunk();
            this.cache.add(chunk);
            ++this.chunkIndex;
            return chunk;
        }
        catch (NoMoreDataException e) {
            this.isFinish = true;
            return null;
        }
    }

    @Override
    public void close() throws ScxIOException {
        this.byteInput.close();
    }

    public void reset() {
        this.chunkIndex = 0;
    }
}

