package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;

/// SpecialCloseByteSupplier
///
/// 具有特殊 close 行为的 ByteSupplier 包装器.
///
/// @author scx567888
/// @version 0.0.1
public final class SpecialCloseByteSupplier implements ByteSupplier {

    private final ByteSupplier byteSupplier;
    /// 在 close 的时候 排空底层 byteSupplier
    private final boolean drainOnClose;
    /// 是否需要调用底层的 close
    private boolean needClose;

    private SpecialCloseByteSupplier(ByteSupplier byteSupplier, boolean needClose, boolean drainOnClose) {
        this.byteSupplier = byteSupplier;
        this.needClose = needClose;
        this.drainOnClose = drainOnClose;
    }

    public static SpecialCloseByteSupplier noClose(ByteSupplier byteSupplier) {
        return new SpecialCloseByteSupplier(byteSupplier, false, false);
    }

    public static SpecialCloseByteSupplier singleClose(ByteSupplier byteSupplier) {
        return new SpecialCloseByteSupplier(byteSupplier, true, false);
    }

    public static SpecialCloseByteSupplier noCloseDrain(ByteSupplier byteSupplier) {
        return new SpecialCloseByteSupplier(byteSupplier, false, true);
    }

    public static SpecialCloseByteSupplier singleCloseDrain(ByteSupplier byteSupplier) {
        return new SpecialCloseByteSupplier(byteSupplier, true, true);
    }

    @Override
    public ByteChunk get() throws Exception {
        return byteSupplier.get();
    }

    @Override
    public void close() throws Exception {

        if (drainOnClose) {
            // 排空 byteSupplier
            while (byteSupplier.get() != null) {
                // 什么都不做
            }
        }

        if (needClose) {
            try {
                byteSupplier.close();
            } finally {
                needClose = false;
            }
        }

    }

    public ByteSupplier byteSupplier() {
        return byteSupplier;
    }

}
