package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;

/// ByteSupplier
///
/// - 它负责从某个上游来源 (如 InputStream, Decoder, File, 甚至另一个 ByteSupplier) 中,
///   执行 "提取 / 缓冲 / 解码 / 转换 / 分帧 / 拆包" 等行为, 并以统一格式输出 ByteChunk.
///
/// - 本质是 数据的生产者 (也可称为转换器) + 资源持有者.
///
/// @author scx567888
/// @version 0.0.1
public interface ByteSupplier extends AutoCloseable {

    /// 获取下一个数据块
    ///
    /// - 必须是推进式的阻塞拉取
    /// - 如果当前已经读取到有效数据 -> 返回 ByteChunk(len > 0)
    /// - 如果暂时无法输出数据, 但 I/O 状态确实推进了 -> 返回 EMPTY_BYTE_CHUNK
    /// - 如果 EOF 且不会再产生数据 -> 返回 null
    /// - 不允许无状态的空循环: 供应者不得无意义地连续返回 EMPTY_BYTE_CHUNK
    /// - 连续多次调用 get() 必须使底层数据源或解码状态单调推进
    ///
    /// @return ByteChunk.
    /// @throws Exception 数据获取过程中发生的任何异常.
    ByteChunk get() throws Exception;

    /// 如果持有底层资源, 在此方法释放资源
    @Override
    default void close() throws Exception {

    }

}
