/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteOutput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import java.io.IOException;
import java.io.OutputStream;

public final class OutputStreamByteOutput
implements ByteOutput {
    private final OutputStream outputStream;
    private boolean closed;

    public OutputStreamByteOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.closed = false;
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
    }

    @Override
    public void write(byte b) throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        try {
            this.outputStream.write(b);
        }
        catch (IOException e) {
            throw new ScxIOException(e);
        }
    }

    @Override
    public void write(ByteChunk b) throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        try {
            this.outputStream.write(b.bytes, b.start, b.length);
        }
        catch (IOException e) {
            throw new ScxIOException(e);
        }
    }

    @Override
    public void flush() throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new ScxIOException(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        try {
            this.outputStream.close();
            this.closed = true;
        }
        catch (IOException e) {
            throw new ScxIOException(e);
        }
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }
}

