/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteInput;
import cool.scx.io.ByteOutput;
import cool.scx.io.DefaultByteInput;
import cool.scx.io.OutputStreamByteOutput;
import cool.scx.io.adapter.ByteInputAdapter;
import cool.scx.io.adapter.ByteInputInputStream;
import cool.scx.io.adapter.ByteOutputAdapter;
import cool.scx.io.adapter.ByteOutputOutputStream;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.supplier.ByteArrayByteSupplier;
import cool.scx.io.supplier.InputStreamByteSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class ScxIO {
    public static DefaultByteInput createByteInput(byte[] ... byteArrays) {
        return new DefaultByteInput(new ByteArrayByteSupplier(byteArrays));
    }

    public static DefaultByteInput createByteInput(InputStream inputStreams) {
        return new DefaultByteInput(new InputStreamByteSupplier(inputStreams));
    }

    public static ByteInput gzipByteInput(ByteInput byteInput) throws ScxIOException {
        try {
            return ScxIO.inputStreamToByteInput(new GZIPInputStream(ScxIO.byteInputToInputStream(byteInput)));
        }
        catch (IOException e) {
            throw new ScxIOException(e);
        }
    }

    public static ByteOutput gzipByteOutput(ByteOutput byteOutput) throws ScxIOException {
        try {
            return ScxIO.outputStreamToByteOutput(new GZIPOutputStream(ScxIO.byteOutputToOutputStream(byteOutput)));
        }
        catch (IOException e) {
            throw new ScxIOException(e);
        }
    }

    public static InputStream byteInputToInputStream(ByteInput byteInput) {
        return new ByteInputInputStream(byteInput);
    }

    public static ByteInput inputStreamToByteInput(InputStream inputStream) {
        if (inputStream instanceof ByteInputAdapter) {
            ByteInputAdapter byteInputAdapter = (ByteInputAdapter)((Object)inputStream);
            return byteInputAdapter.byteInput();
        }
        return new DefaultByteInput(new InputStreamByteSupplier(inputStream));
    }

    public static OutputStream byteOutputToOutputStream(ByteOutput byteOutput) {
        if (byteOutput instanceof OutputStreamByteOutput) {
            OutputStreamByteOutput outputStreamByteOutput = (OutputStreamByteOutput)byteOutput;
            return outputStreamByteOutput.outputStream();
        }
        return new ByteOutputOutputStream(byteOutput);
    }

    public static ByteOutput outputStreamToByteOutput(OutputStream outputStream) {
        if (outputStream instanceof ByteOutputAdapter) {
            ByteOutputAdapter byteOutputAdapter = (ByteOutputAdapter)((Object)outputStream);
            return byteOutputAdapter.byteOutput();
        }
        return new OutputStreamByteOutput(outputStream);
    }
}

