/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.consumer;

import cool.scx.io.ByteChunk;
import cool.scx.io.consumer.ByteConsumer;

public final class FillByteArrayByteConsumer
implements ByteConsumer<RuntimeException> {
    private final byte[] data;
    private final int position;
    private final int length;
    private int bytesFilled;

    public FillByteArrayByteConsumer(byte[] data) {
        this(data, 0, data.length);
    }

    public FillByteArrayByteConsumer(byte[] data, int position, int length) {
        this.data = data;
        this.position = position;
        this.length = length;
        this.bytesFilled = 0;
    }

    @Override
    public boolean accept(ByteChunk byteChunk) throws IndexOutOfBoundsException {
        if (this.bytesFilled + byteChunk.length > this.length) {
            throw new IndexOutOfBoundsException("Buffer overflow: not enough space to accept more data");
        }
        System.arraycopy(byteChunk.bytes, byteChunk.start, this.data, this.position + this.bytesFilled, byteChunk.length);
        this.bytesFilled += byteChunk.length;
        return true;
    }

    public int bytesFilled() {
        return this.bytesFilled;
    }
}

