/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.consumer.ByteChunkByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.supplier.ByteSupplier;

public final class FixedLengthByteSupplier
implements ByteSupplier {
    private final ByteInput byteInput;
    private final ByteChunkByteConsumer consumer;
    private long remaining;

    public FixedLengthByteSupplier(ByteInput byteInput, long maxLength) {
        this.byteInput = byteInput;
        this.consumer = new ByteChunkByteConsumer();
        this.remaining = maxLength;
    }

    @Override
    public ByteChunk get() throws AlreadyClosedException, ScxIOException {
        if (this.remaining <= 0L) {
            return null;
        }
        try {
            this.byteInput.read(this.consumer, this.remaining);
            ByteChunk byteChunk = this.consumer.byteChunk();
            this.remaining -= (long)byteChunk.length;
            return byteChunk;
        }
        catch (NoMoreDataException e) {
            return null;
        }
    }

    @Override
    public void close() throws ScxIOException, AlreadyClosedException {
        this.byteInput.close();
    }

    public ByteInput byteInput() {
        return this.byteInput;
    }
}

