/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.supplier.ByteSupplier;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamByteSupplier
implements ByteSupplier {
    private final InputStream inputStream;
    private final int bufferLength;
    private final boolean compress;

    public InputStreamByteSupplier(InputStream inputStream) {
        this(inputStream, 8192, false);
    }

    public InputStreamByteSupplier(InputStream inputStream, boolean compress) {
        this(inputStream, 8192, compress);
    }

    public InputStreamByteSupplier(InputStream inputStream, int bufferLength) {
        this(inputStream, bufferLength, false);
    }

    public InputStreamByteSupplier(InputStream inputStream, int bufferLength, boolean compress) {
        this.inputStream = inputStream;
        this.bufferLength = bufferLength;
        this.compress = compress;
    }

    @Override
    public ByteChunk get() throws IOException {
        byte[] bytes = new byte[this.bufferLength];
        int i = this.inputStream.read(bytes);
        if (i == -1) {
            return null;
        }
        if (i == this.bufferLength) {
            return ByteChunk.of(bytes);
        }
        if (this.compress) {
            byte[] data = new byte[i];
            System.arraycopy(bytes, 0, data, 0, i);
            return ByteChunk.of(data);
        }
        return ByteChunk.of(bytes, 0, i);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public InputStream inputStream() {
        return this.inputStream;
    }
}

