/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.supplier.ByteSupplier;

public final class SpecialCloseByteSupplier
implements ByteSupplier {
    private final ByteSupplier byteSupplier;
    private final boolean drainOnClose;
    private boolean needClose;

    private SpecialCloseByteSupplier(ByteSupplier byteSupplier, boolean needClose, boolean drainOnClose) {
        this.byteSupplier = byteSupplier;
        this.needClose = needClose;
        this.drainOnClose = drainOnClose;
    }

    public static SpecialCloseByteSupplier noClose(ByteSupplier byteSupplier) {
        return new SpecialCloseByteSupplier(byteSupplier, false, false);
    }

    public static SpecialCloseByteSupplier singleClose(ByteSupplier byteSupplier) {
        return new SpecialCloseByteSupplier(byteSupplier, true, false);
    }

    public static SpecialCloseByteSupplier noCloseDrain(ByteSupplier byteSupplier) {
        return new SpecialCloseByteSupplier(byteSupplier, false, true);
    }

    public static SpecialCloseByteSupplier singleCloseDrain(ByteSupplier byteSupplier) {
        return new SpecialCloseByteSupplier(byteSupplier, true, true);
    }

    @Override
    public ByteChunk get() throws Exception {
        return this.byteSupplier.get();
    }

    @Override
    public void close() throws Exception {
        if (this.drainOnClose) {
            while (this.byteSupplier.get() != null) {
            }
        }
        if (this.needClose) {
            this.byteSupplier.close();
            this.needClose = false;
        }
    }

    public ByteSupplier byteSupplier() {
        return this.byteSupplier;
    }
}

