/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.consumer;

import cool.scx.io.ByteChunk;
import cool.scx.io.consumer.ByteConsumer;

public final class ByteArrayByteConsumer
implements ByteConsumer<RuntimeException> {
    private ByteChunkNode head = null;
    private ByteChunkNode tail = null;
    private int total = 0;

    @Override
    public boolean accept(ByteChunk byteChunk) {
        this.total += byteChunk.length;
        ByteChunkNode dataNode = new ByteChunkNode(byteChunk);
        this.tail = this.head == null ? (this.head = dataNode) : (this.tail.next = dataNode);
        return true;
    }

    public byte[] bytes() {
        ByteChunkNode node = this.head;
        if (node == null) {
            return new byte[0];
        }
        if (node.next == null) {
            return node.chunk.getBytes();
        }
        byte[] bytes = new byte[this.total];
        int offset = 0;
        do {
            int chunkLength = node.chunk.length;
            int chunkOffset = node.chunk.start;
            System.arraycopy(node.chunk.bytes, chunkOffset, bytes, offset, chunkLength);
            offset += chunkLength;
        } while ((node = node.next) != null);
        return bytes;
    }

    private static class ByteChunkNode {
        public final ByteChunk chunk;
        public ByteChunkNode next;

        public ByteChunkNode(ByteChunk chunk) {
            this.chunk = chunk;
        }
    }
}

