/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.indexer;

import cool.scx.io.ByteChunk;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.indexer.StatusByteMatchResult;

public final class BitMaskByteIndexer
implements ByteIndexer {
    private final byte[] pattern;
    private final long[] mask;
    private long state;

    public BitMaskByteIndexer(byte[] pattern) {
        if (pattern.length > 64) {
            throw new IllegalArgumentException("BitMaskByteIndexer only supports pattern length <= 64");
        }
        this.pattern = pattern;
        this.mask = BitMaskByteIndexer.buildMask(pattern);
        this.state = 0L;
    }

    private static long[] buildMask(byte[] pattern) {
        long[] mask = new long[256];
        for (int i = 0; i < pattern.length; ++i) {
            int idx;
            int n = idx = pattern[i] & 0xFF;
            mask[n] = mask[n] | 1L << i;
        }
        return mask;
    }

    @Override
    public StatusByteMatchResult indexOf(ByteChunk chunk) {
        long endBit = 1L << this.pattern.length - 1;
        for (int i = 0; i < chunk.length; ++i) {
            byte currentByte = chunk.getByte(i);
            int idx = currentByte & 0xFF;
            long m = this.mask[idx];
            this.state = (this.state << 1 | 1L) & m;
            if ((this.state & endBit) == 0L) continue;
            this.state = 0L;
            return StatusByteMatchResult.fullMatch(i - (this.pattern.length - 1), this.pattern.length);
        }
        return this.state == 0L ? StatusByteMatchResult.NO_MATCH_RESULT : StatusByteMatchResult.PARTIAL_MATCH_RESULT;
    }

    @Override
    public boolean isEmptyPattern() {
        return this.pattern.length == 0;
    }

    @Override
    public void reset() {
        this.state = 0L;
    }
}

