package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;

/// NullByteSupplier
///
/// @author scx567888
/// @version 0.0.1
public final class NullByteSupplier implements ByteSupplier {

    public static final NullByteSupplier NULL_BYTE_SUPPLIER = new NullByteSupplier(null);

    private final AutoCloseable closeable;

    public NullByteSupplier(AutoCloseable closeable) {
        this.closeable = closeable;
    }

    @Override
    public ByteChunk get() {
        return null;
    }

    @Override
    public void close() throws Exception {
        if (closeable != null) {
            closeable.close();
        }
    }

}
