/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteOutput;
import cool.scx.io.consumer.ByteArrayByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

public final class ByteArrayByteOutput
implements ByteOutput {
    private final ByteArrayByteConsumer byteConsumer = new ByteArrayByteConsumer();
    private boolean closed = false;

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
    }

    @Override
    public void write(byte b) throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        this.byteConsumer.accept(ByteChunk.of(b));
    }

    @Override
    public void write(ByteChunk b) throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        this.byteConsumer.accept(b);
    }

    @Override
    public void flush() throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        this.closed = true;
    }

    public byte[] bytes() {
        return this.byteConsumer.bytes();
    }
}

