/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteInputMark;
import cool.scx.io.ByteMatchResult;
import cool.scx.io.ByteOutput;
import cool.scx.io.consumer.ByteArrayByteConsumer;
import cool.scx.io.consumer.ByteConsumer;
import cool.scx.io.consumer.ByteOutputByteConsumer;
import cool.scx.io.consumer.SkipByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.indexer.KMPByteIndexer;
import cool.scx.io.indexer.SingleByteIndexer;

public interface ByteInput
extends AutoCloseable {
    public byte read() throws ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void read(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void readUpTo(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void readFully(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public byte peek() throws ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void peek(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void peekUpTo(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public <X extends Throwable> void peekFully(ByteConsumer<X> var1, long var2) throws X, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public ByteMatchResult indexOf(ByteIndexer var1, long var2) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException;

    public ByteInputMark mark() throws AlreadyClosedException;

    public boolean isClosed();

    @Override
    public void close() throws ScxIOException, AlreadyClosedException;

    default public byte[] read(int maxLength) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.read(consumer, maxLength);
        return consumer.bytes();
    }

    default public byte[] readUpTo(int length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.readUpTo(consumer, length);
        return consumer.bytes();
    }

    default public byte[] readFully(int length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.readFully(consumer, length);
        return consumer.bytes();
    }

    default public byte[] readAll() throws ScxIOException, AlreadyClosedException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.readAll(consumer);
        return consumer.bytes();
    }

    default public <X extends Throwable> void readAll(ByteConsumer<X> byteConsumer) throws X, ScxIOException, AlreadyClosedException {
        try {
            this.readUpTo(byteConsumer, Long.MAX_VALUE);
        }
        catch (NoMoreDataException noMoreDataException) {
            // empty catch block
        }
    }

    default public byte[] peek(int maxLength) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peek(consumer, maxLength);
        return consumer.bytes();
    }

    default public byte[] peekUpTo(int length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peekUpTo(consumer, length);
        return consumer.bytes();
    }

    default public byte[] peekFully(int length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peekFully(consumer, length);
        return consumer.bytes();
    }

    default public byte[] peekAll() throws ScxIOException, AlreadyClosedException {
        ByteArrayByteConsumer consumer = new ByteArrayByteConsumer();
        this.peekAll(consumer);
        return consumer.bytes();
    }

    default public <X extends Throwable> void peekAll(ByteConsumer<X> byteConsumer) throws X, ScxIOException, AlreadyClosedException {
        try {
            this.peekUpTo(byteConsumer, Long.MAX_VALUE);
        }
        catch (NoMoreDataException noMoreDataException) {
            // empty catch block
        }
    }

    default public long skip(long maxLength) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        SkipByteConsumer consumer = new SkipByteConsumer();
        this.read(consumer, maxLength);
        return consumer.bytesSkipped();
    }

    default public long skipUpTo(long length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        SkipByteConsumer consumer = new SkipByteConsumer();
        this.readUpTo(consumer, length);
        return consumer.bytesSkipped();
    }

    default public long skipFully(long length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        SkipByteConsumer consumer = new SkipByteConsumer();
        this.readFully(consumer, length);
        return consumer.bytesSkipped();
    }

    default public long skipAll() throws ScxIOException, AlreadyClosedException {
        SkipByteConsumer consumer = new SkipByteConsumer();
        this.readAll(consumer);
        return consumer.bytesSkipped();
    }

    default public ByteMatchResult indexOf(ByteIndexer byteIndexer) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(byteIndexer, Long.MAX_VALUE);
    }

    default public ByteMatchResult indexOf(byte b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public ByteMatchResult indexOf(byte b, long maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(new SingleByteIndexer(b), maxLength);
    }

    default public ByteMatchResult indexOf(byte[] b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public ByteMatchResult indexOf(byte[] b, long maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.indexOf(new KMPByteIndexer(b), maxLength);
    }

    default public byte[] readUntil(ByteIndexer byteIndexer) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.readUntil(byteIndexer, Integer.MAX_VALUE);
    }

    default public byte[] readUntil(ByteIndexer byteIndexer, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteMatchResult indexMatchResult = this.indexOf(byteIndexer, (long)maxLength);
        byte[] bytes = this.readFully((int)indexMatchResult.index);
        this.skipFully(indexMatchResult.matchedLength);
        return bytes;
    }

    default public byte[] readUntil(byte b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.readUntil(b, Integer.MAX_VALUE);
    }

    default public byte[] readUntil(byte b, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.readUntil(new SingleByteIndexer(b), maxLength);
    }

    default public byte[] readUntil(byte[] b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.readUntil(b, Integer.MAX_VALUE);
    }

    default public byte[] readUntil(byte[] b, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.readUntil(new KMPByteIndexer(b), maxLength);
    }

    default public byte[] peekUntil(ByteIndexer byteIndexer) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.peekUntil(byteIndexer, Integer.MAX_VALUE);
    }

    default public byte[] peekUntil(ByteIndexer byteIndexer, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteMatchResult indexMatchResult = this.indexOf(byteIndexer, (long)maxLength);
        return this.peekFully((int)indexMatchResult.index);
    }

    default public byte[] peekUntil(byte b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.peekUntil(b, Integer.MAX_VALUE);
    }

    default public byte[] peekUntil(byte b, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.peekUntil(new SingleByteIndexer(b), maxLength);
    }

    default public byte[] peekUntil(byte[] b) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.peekUntil(b, Integer.MAX_VALUE);
    }

    default public byte[] peekUntil(byte[] b, int maxLength) throws NoMatchFoundException, ScxIOException, AlreadyClosedException, NoMoreDataException {
        return this.peekUntil(new KMPByteIndexer(b), maxLength);
    }

    default public long transferTo(ByteOutput byteOutput, long maxLength) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteOutputByteConsumer consumer = new ByteOutputByteConsumer(byteOutput);
        this.read(consumer, maxLength);
        return consumer.bytesWritten();
    }

    default public long transferToUpTo(ByteOutput byteOutput, long length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteOutputByteConsumer consumer = new ByteOutputByteConsumer(byteOutput);
        this.readUpTo(consumer, length);
        return consumer.bytesWritten();
    }

    default public long transferToFully(ByteOutput byteOutput, long length) throws ScxIOException, AlreadyClosedException, NoMoreDataException {
        ByteOutputByteConsumer consumer = new ByteOutputByteConsumer(byteOutput);
        this.readFully(consumer, length);
        return consumer.bytesWritten();
    }

    default public long transferToAll(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        ByteOutputByteConsumer consumer = new ByteOutputByteConsumer(byteOutput);
        this.readAll(consumer);
        return consumer.bytesWritten();
    }
}

