/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteOutput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

public final class LengthBoundedOutput
implements ByteOutput {
    private final ByteOutput byteOutput;
    private final long minLength;
    private final long maxLength;
    private long bytesWritten;

    public LengthBoundedOutput(ByteOutput byteOutput, long minLength, long maxLength) {
        this.byteOutput = byteOutput;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.bytesWritten = 0L;
    }

    private void ensureMax(int length) throws ScxIOException {
        if (this.bytesWritten + (long)length > this.maxLength) {
            throw new ScxIOException("\u5199\u5165\u8d85\u51fa\u6700\u5927\u957f\u5ea6: \u5df2\u5199\u5165 " + this.bytesWritten + ", \u672c\u6b21\u5199\u5165 " + length + ", \u6700\u5927\u5141\u8bb8 " + this.maxLength);
        }
    }

    private void ensureMin() throws ScxIOException {
        if (this.bytesWritten < this.minLength) {
            throw new ScxIOException("\u5199\u5165\u957f\u5ea6\u4e0d\u8db3: \u5df2\u5199\u5165 " + this.bytesWritten + ", \u6700\u5c0f\u957f\u5ea6\u8981\u6c42 " + this.minLength);
        }
    }

    @Override
    public void write(byte b) throws ScxIOException, AlreadyClosedException {
        this.ensureMax(1);
        this.byteOutput.write(b);
        ++this.bytesWritten;
    }

    @Override
    public void write(ByteChunk b) throws ScxIOException, AlreadyClosedException {
        this.ensureMax(b.length);
        this.byteOutput.write(b);
        this.bytesWritten += (long)b.length;
    }

    @Override
    public void flush() throws ScxIOException, AlreadyClosedException {
        this.byteOutput.flush();
    }

    @Override
    public boolean isClosed() {
        return this.byteOutput.isClosed();
    }

    @Override
    public void close() throws ScxIOException, AlreadyClosedException {
        this.ensureMin();
        this.byteOutput.close();
    }

    public ByteOutput byteOutput() {
        return this.byteOutput;
    }
}

