/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteChunk;
import cool.scx.io.ByteOutput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

public final class NoCloseByteOutput
implements ByteOutput {
    private final ByteOutput byteOutput;
    private boolean closed;

    public NoCloseByteOutput(ByteOutput byteOutput) {
        this.byteOutput = byteOutput;
        this.closed = false;
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
    }

    @Override
    public void write(byte b) throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        this.byteOutput.write(b);
    }

    @Override
    public void write(ByteChunk b) throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        this.byteOutput.write(b);
    }

    @Override
    public void flush() throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        this.byteOutput.flush();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws ScxIOException, AlreadyClosedException {
        this.ensureOpen();
        this.byteOutput.flush();
        this.closed = true;
    }

    public ByteOutput byteOutput() {
        return this.byteOutput;
    }
}

