/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.supplier;

import cool.scx.io.ByteChunk;
import cool.scx.io.supplier.ByteSupplier;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileByteSupplier
implements ByteSupplier {
    private final RandomAccessFile randomAccessFile;
    private final int bufferLength;
    private long remaining;

    public FileByteSupplier(File file) throws IOException {
        this(file, 0L, file.length(), 8192);
    }

    public FileByteSupplier(File file, int bufferLength) throws IOException {
        this(file, 0L, file.length(), bufferLength);
    }

    public FileByteSupplier(File file, long offset, long length) throws IOException {
        this(file, offset, length, 8192);
    }

    public FileByteSupplier(File file, long offset, long length, int bufferLength) throws IOException {
        if (offset < 0L || length < 0L || offset + length > file.length()) {
            throw new IllegalArgumentException("offset/length out of file bounds");
        }
        this.bufferLength = bufferLength;
        this.remaining = length;
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.randomAccessFile.seek(offset);
    }

    @Override
    public ByteChunk get() throws IOException {
        if (this.remaining <= 0L) {
            return null;
        }
        byte[] bytes = new byte[this.bufferLength];
        int i = this.randomAccessFile.read(bytes, 0, (int)Math.min((long)this.bufferLength, this.remaining));
        if (i == -1) {
            return null;
        }
        this.remaining -= (long)i;
        return ByteChunk.of(bytes, 0, i);
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }
}

