/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mysql;

import com.mysql.cj.MysqlType;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.jdbc.MysqlDataSource;
import com.mysql.cj.jdbc.NonRegisteringDriver;
import cool.scx.common.util.StringUtils;
import cool.scx.jdbc.JDBCType;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.mysql.MySQLDialectHelper;
import cool.scx.jdbc.type_handler.TypeHandler;
import cool.scx.jdbc.type_handler.TypeHandlerSelector;
import cool.scx.reflect.TypeInfo;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class MySQLDialect
implements Dialect {
    private static final NonRegisteringDriver DRIVER = MySQLDialect.initDRIVER();
    private final TypeHandlerSelector typeHandlerSelector = new TypeHandlerSelector();

    private static NonRegisteringDriver initDRIVER() {
        try {
            return new NonRegisteringDriver();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canHandle(String url) {
        try {
            return DRIVER.acceptsURL(url);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean canHandle(DataSource dataSource) {
        try {
            return dataSource instanceof MysqlDataSource || dataSource.isWrapperFor(MysqlDataSource.class);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean canHandle(Driver driver) {
        return driver instanceof com.mysql.cj.jdbc.Driver;
    }

    public String getFinalSQL(Statement preparedStatement) {
        ClientPreparedStatement clientPreparedStatement;
        try {
            clientPreparedStatement = preparedStatement.unwrap(ClientPreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        PreparedQuery preparedQuery = (PreparedQuery)clientPreparedStatement.getQuery();
        String finalSQL = preparedQuery.asSql();
        int batchedArgsSize = preparedQuery.getBatchedArgs() == null ? 0 : preparedQuery.getBatchedArgs().size();
        return batchedArgsSize > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchedArgsSize - 1) + " \u9879" : finalSQL;
    }

    public DataSource createDataSource(String url, String username, String password, String[] parameters) {
        MysqlDataSource mysqlDataSource = new MysqlDataSource();
        mysqlDataSource.setUrl(url);
        mysqlDataSource.setUser(username);
        mysqlDataSource.setPassword(password);
        for (String parameter : parameters) {
            String[] p = parameter.split("=");
            if (p.length != 2) continue;
            RuntimeProperty property = mysqlDataSource.getProperty(p[0]);
            property.setValue(property.getPropertyDefinition().parseObject(p[1], null));
        }
        return mysqlDataSource;
    }

    public PreparedStatement beforeExecuteQuery(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setFetchSize(Integer.MIN_VALUE);
        return preparedStatement;
    }

    public <T> TypeHandler<T> findTypeHandler(Class<?> type) {
        return this.typeHandlerSelector.findTypeHandler(type);
    }

    public <T> TypeHandler<T> findTypeHandler(TypeInfo type) {
        return this.typeHandlerSelector.findTypeHandler(type);
    }

    public JDBCType dialectDataTypeToJDBCType(String dialectDataType) {
        return MySQLDialectHelper.dialectDataTypeToJDBCType(dialectDataType);
    }

    public String jdbcTypeToDialectDataType(JDBCType jdbcType) {
        return MySQLDialectHelper.jdbcTypeToDialectDataType(jdbcType).getName();
    }

    public String quoteIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    public List<String> getColumnConstraint(Column column) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(column.notNull() || column.primary() ? "NOT NULL" : "NULL");
        if (column.autoIncrement()) {
            list.add("AUTO_INCREMENT");
        }
        if (StringUtils.notBlank((String)column.defaultValue())) {
            list.add("DEFAULT " + column.defaultValue());
        }
        if (StringUtils.notBlank((String)column.onUpdate())) {
            list.add("ON UPDATE " + column.onUpdate());
        }
        return list;
    }

    public String getDataTypeNameByJDBCType(JDBCType dataType) {
        MysqlType mysqlType = MySQLDialectHelper.jdbcTypeToDialectDataType(dataType);
        return mysqlType.getName();
    }

    public List<String> getTableConstraint(Table table) {
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : table.columns()) {
            String key;
            String name = column.name();
            if (column.primary()) {
                list.add("PRIMARY KEY (" + this.quoteIdentifier(name) + ")");
            }
            if (column.unique()) {
                key = "unique_" + name;
                list.add("UNIQUE KEY " + this.quoteIdentifier(key) + "(" + this.quoteIdentifier(name) + ")");
            }
            if (!column.index()) continue;
            key = "index_" + name;
            list.add("KEY " + this.quoteIdentifier(key) + "(" + this.quoteIdentifier(name) + ")");
        }
        return list;
    }

    public String defaultDataType() {
        return "VARCHAR(128)";
    }
}

