/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.spy.event;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.spy.event.SimpleJdbcEventListener;
import java.sql.SQLException;
import java.sql.Statement;

public class LoggingEventListener
extends SimpleJdbcEventListener {
    private static final System.Logger logger = System.getLogger("ScxSpy");
    private final Dialect dialect;

    public LoggingEventListener(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public void onBeforeAnyExecute(Statement statement) {
        if (logger.isLoggable(System.Logger.Level.DEBUG)) {
            logger.log(System.Logger.Level.DEBUG, this.dialect.getFinalSQL(statement));
        }
    }

    @Override
    public void onAfterAnyExecute(Statement statement, long timeElapsedNanos, SQLException e) {
    }

    @Override
    public void onBeforeAnyAddBatch(Statement Statement2) {
        super.onBeforeAnyAddBatch(Statement2);
    }

    @Override
    public void onAfterAnyAddBatch(Statement Statement2, long timeElapsedNanos, SQLException e) {
        super.onAfterAnyAddBatch(Statement2, timeElapsedNanos, e);
    }
}

