/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.spy;

import cool.scx.jdbc.dialect.DialectSelector;
import cool.scx.jdbc.spy.SpyEventListener;
import cool.scx.jdbc.spy.event_listener.LoggingEventListener;
import cool.scx.jdbc.spy.wrapper.DataSourceWrapper;
import java.sql.Driver;
import java.util.function.Function;
import javax.sql.DataSource;

public class Spy {
    private static Function<DataSource, SpyEventListener> eventListenerBuilderByDataSource = dataSource -> new LoggingEventListener(DialectSelector.findDialect((DataSource)dataSource));
    private static Function<Driver, SpyEventListener> eventListenerBuilderByDriver = driver -> new LoggingEventListener(DialectSelector.findDialect((Driver)driver));

    public static DataSource wrap(DataSource dataSource) {
        return Spy.wrap(dataSource, Spy.buildEventListener(dataSource));
    }

    public static DataSource wrap(DataSource dataSource, SpyEventListener eventListener) {
        DataSourceWrapper dataSourceWrapper;
        if (dataSource instanceof DataSourceWrapper) {
            DataSourceWrapper w = (DataSourceWrapper)dataSource;
            dataSourceWrapper = new DataSourceWrapper((DataSource)w.delegate, eventListener);
        } else {
            dataSourceWrapper = new DataSourceWrapper(dataSource, eventListener);
        }
        return dataSourceWrapper;
    }

    static SpyEventListener buildEventListener(DataSource dataSource) {
        return eventListenerBuilderByDataSource.apply(dataSource);
    }

    static SpyEventListener buildEventListener(Driver driver) {
        return eventListenerBuilderByDriver.apply(driver);
    }

    public static Function<DataSource, SpyEventListener> getEventListenerBuilderByDataSource() {
        return eventListenerBuilderByDataSource;
    }

    public static void setEventListenerBuilderByDataSource(Function<DataSource, SpyEventListener> eventListenerBuilderByDataSource) {
        Spy.eventListenerBuilderByDataSource = eventListenerBuilderByDataSource;
    }

    public static Function<Driver, SpyEventListener> getEventListenerBuilderByDriver() {
        return eventListenerBuilderByDriver;
    }

    public static void setEventListenerBuilderByDriver(Function<Driver, SpyEventListener> eventListenerBuilderByDriver) {
        Spy.eventListenerBuilderByDriver = eventListenerBuilderByDriver;
    }
}

