/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.bean_builder;

import cool.scx.jdbc.type_handler.TypeHandler;
import cool.scx.util.reflect.FieldUtils;
import java.lang.reflect.Field;
import java.util.function.Function;

final class FieldSetter {
    private final Field javaField;
    private final String columnName;
    private TypeHandler<?> typeHandler;

    FieldSetter(Field javaField, String columnName) {
        this.javaField = javaField;
        this.columnName = columnName;
        this.typeHandler = null;
    }

    static FieldSetter of(Field field, Function<Field, String> columnNameMapping) {
        field.setAccessible(true);
        String columnName = columnNameMapping.apply(field);
        if (columnName == null) {
            columnName = field.getName();
        }
        return new FieldSetter(field, columnName);
    }

    static FieldSetter[] ofArray(Class<?> type, Function<Field, String> columnNameMapping) {
        Field[] fields = FieldUtils.findFields(type);
        FieldSetter[] fieldSetters = new FieldSetter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldSetters[i] = FieldSetter.of(fields[i], columnNameMapping);
        }
        return fieldSetters;
    }

    public void bindTypeHandler(TypeHandler<Object> typeHandler) {
        this.typeHandler = typeHandler;
    }

    public Field javaField() {
        return this.javaField;
    }

    public String columnName() {
        return this.columnName;
    }

    public TypeHandler<?> typeHandler() {
        return this.typeHandler;
    }
}

