/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.dialect;

import cool.scx.jdbc.ColumnMapping;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.type_handler.TypeHandler;
import cool.scx.jdbc.type_handler.TypeHandlerSelector;
import cool.scx.util.StringUtils;
import java.lang.reflect.Type;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public abstract class Dialect {
    protected final TypeHandlerSelector typeHandlerSelector = new TypeHandlerSelector();

    public abstract boolean canHandle(String var1);

    public abstract boolean canHandle(DataSource var1);

    public abstract boolean canHandle(Driver var1);

    public abstract String getFinalSQL(Statement var1);

    public abstract String getLimitSQL(String var1, Long var2, Long var3);

    public abstract DataSource createDataSource(String var1, String var2, String var3, String[] var4);

    public final String getCreateTableDDL(Table<?> tableInfo) {
        StringBuilder s = new StringBuilder();
        s.append("CREATE TABLE ");
        if (StringUtils.notEmpty((String)tableInfo.schema())) {
            s.append(tableInfo.schema()).append(".");
        }
        s.append(tableInfo.name()).append("\n");
        s.append("(\n");
        String createDefinitionStr = this.getCreateDefinition(tableInfo).stream().map(c -> "    " + c).collect(Collectors.joining(",\n"));
        s.append(createDefinitionStr);
        s.append("\n);");
        return s.toString();
    }

    public final List<String> getCreateDefinition(Table<?> table) {
        ArrayList<String> createDefinitions = new ArrayList<String>();
        createDefinitions.addAll(this.getColumnDefinitions(table.columns()));
        createDefinitions.addAll(this.getTableConstraint(table));
        return createDefinitions;
    }

    public final List<String> getColumnDefinitions(Column[] columns) {
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns) {
            list.add(this.getColumnDefinition(column));
        }
        return list;
    }

    public List<String> getTableConstraint(Table<?> table) {
        return new ArrayList<String>();
    }

    public final String getColumnDefinition(Column column) {
        StringBuilder s = new StringBuilder();
        s.append(column.name()).append(" ");
        String dataTypeDefinition = this.getDataTypeDefinition(column);
        if (dataTypeDefinition != null) {
            s.append(dataTypeDefinition).append(" ");
        }
        String columnConstraintStr = String.join((CharSequence)" ", this.getColumnConstraint(column));
        s.append(columnConstraintStr);
        return s.toString();
    }

    public final String getDataTypeDefinition(Column column) {
        if (column.typeName() != null) {
            if (column.columnSize() != null) {
                return column.typeName() + "(" + column.columnSize() + ")";
            }
            return column.typeName();
        }
        if (column instanceof ColumnMapping) {
            ColumnMapping m = (ColumnMapping)column;
            return this.getDataTypeDefinitionByClass(m.javaField().getType());
        }
        return this.defaultDateType();
    }

    public abstract List<String> getColumnConstraint(Column var1);

    public abstract String getDataTypeDefinitionByClass(Class<?> var1);

    public String defaultDateType() {
        return null;
    }

    public final String getAlertTableDDL(Column[] needAdds, Table<?> tableInfo) {
        StringBuilder s = new StringBuilder();
        s.append("ALTER TABLE ");
        if (StringUtils.notEmpty((String)tableInfo.schema())) {
            s.append(tableInfo.schema()).append(".");
        }
        s.append(tableInfo.name()).append("\n");
        String columnDefinitionStr = this.getColumnDefinitions(needAdds).stream().map(c -> "    ADD COLUMN " + c).collect(Collectors.joining(",\n"));
        s.append(columnDefinitionStr);
        s.append("\n;");
        return s.toString();
    }

    public PreparedStatement beforeExecuteQuery(PreparedStatement preparedStatement) throws SQLException {
        return preparedStatement;
    }

    public final <T> TypeHandler<T> findTypeHandler(Type type) {
        return this.typeHandlerSelector.findTypeHandler(type);
    }
}

