/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sql;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

final class PlaceholderSQL
implements SQL {
    private final boolean isBatch;
    private final String normalSQL;
    private final Object[] params;
    private final List<Object[]> batchParams;

    public PlaceholderSQL(String normalSQL, Object[] params) {
        this.isBatch = false;
        this.normalSQL = normalSQL;
        this.params = params;
        this.batchParams = null;
    }

    public PlaceholderSQL(String normalSQL, List<Object[]> batchParams) {
        this.isBatch = true;
        this.normalSQL = normalSQL;
        this.params = null;
        this.batchParams = batchParams;
    }

    public static void fillPreparedStatement(PreparedStatement preparedStatement, Object[] params, Dialect dialect) throws SQLException {
        int index = 1;
        for (Object tempValue : params) {
            if (tempValue == null) {
                preparedStatement.setNull(index, 0);
            } else {
                TypeHandler<Object> typeHandler = dialect.findTypeHandler(tempValue.getClass());
                typeHandler.setObject(preparedStatement, index, tempValue);
            }
            ++index;
        }
    }

    private PreparedStatement fillSingle(PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        if (this.params != null) {
            PlaceholderSQL.fillPreparedStatement(preparedStatement, this.params, typeHandlerSelector);
        }
        return preparedStatement;
    }

    private PreparedStatement fillBatch(PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        if (this.batchParams != null) {
            for (Object[] paramArray : this.batchParams) {
                if (paramArray == null) continue;
                PlaceholderSQL.fillPreparedStatement(preparedStatement, paramArray, typeHandlerSelector);
                preparedStatement.addBatch();
            }
        }
        return preparedStatement;
    }

    @Override
    public Object[] params() {
        return this.params;
    }

    @Override
    public PreparedStatement fillParams(PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        return this.isBatch ? this.fillBatch(preparedStatement, typeHandlerSelector) : this.fillSingle(preparedStatement, typeHandlerSelector);
    }

    @Override
    public String sql() {
        return this.normalSQL;
    }
}

