/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.type_handler.time;

import cool.scx.constant.ScxDateTimeFormatter;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.LocalDateTime;

public class LocalDateTimeTypeHandler
implements TypeHandler<LocalDateTime> {
    @Override
    public void setObject(PreparedStatement ps, int i, LocalDateTime parameter) throws SQLException {
        try {
            ps.setObject(i, parameter);
        }
        catch (SQLFeatureNotSupportedException e) {
            ps.setString(i, ScxDateTimeFormatter.yyyy_MM_dd_HH_mm_ss.format(parameter));
        }
    }

    @Override
    public LocalDateTime getObject(ResultSet rs, int index) throws SQLException {
        try {
            return rs.getObject(index, LocalDateTime.class);
        }
        catch (SQLFeatureNotSupportedException e) {
            String str = rs.getString(index);
            return str == null ? null : ScxDateTimeFormatter.yyyy_MM_dd_HH_mm_ss.parse((CharSequence)str, LocalDateTime::from);
        }
    }
}

