/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sql;

import cool.scx.functional.ScxConsumer;
import cool.scx.functional.ScxFunction;
import cool.scx.functional.ScxRunnable;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.UpdateResult;
import cool.scx.jdbc.type_handler.TypeHandler;
import cool.scx.util.ScxExceptionHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public final class SQLRunner {
    private static final InheritableThreadLocal<Connection> CONNECTION_THREAD_LOCAL = new InheritableThreadLocal();
    private final AtomicLong threadNumber = new AtomicLong(0L);
    private final JDBCContext jdbcContext;

    public SQLRunner(JDBCContext jdbcContext) {
        this.jdbcContext = jdbcContext;
    }

    public static void autoTransaction(Connection con, ScxConsumer<Connection, Exception> handler) throws Exception {
        con.setAutoCommit(false);
        try {
            handler.accept((Object)con);
            con.commit();
        }
        catch (Exception e) {
            con.rollback();
            throw e;
        }
    }

    public static <T> T autoTransaction(Connection con, ScxFunction<Connection, T, Exception> handler) throws Exception {
        con.setAutoCommit(false);
        try {
            Object result = handler.apply((Object)con);
            con.commit();
            return (T)result;
        }
        catch (Exception e) {
            con.rollback();
            throw e;
        }
    }

    private static List<Long> getGeneratedKeys(PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
    }

    private static PreparedStatement fillParams(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        return sql.isBatch() ? SQLRunner.fillBatch(sql, preparedStatement, typeHandlerSelector) : SQLRunner.fillSingle(sql, preparedStatement, typeHandlerSelector);
    }

    private static PreparedStatement fillSingle(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        if (sql.params() != null) {
            SQLRunner.fillPreparedStatement(preparedStatement, sql.params(), typeHandlerSelector);
        }
        return preparedStatement;
    }

    private static PreparedStatement fillBatch(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        if (sql.batchParams() != null) {
            for (Object[] paramArray : sql.batchParams()) {
                if (paramArray == null) continue;
                SQLRunner.fillPreparedStatement(preparedStatement, paramArray, typeHandlerSelector);
                preparedStatement.addBatch();
            }
        }
        return preparedStatement;
    }

    private static void fillPreparedStatement(PreparedStatement preparedStatement, Object[] params, Dialect dialect) throws SQLException {
        int index = 1;
        for (Object tempValue : params) {
            if (tempValue == null) {
                preparedStatement.setNull(index, 0);
            } else {
                TypeHandler<Object> typeHandler = dialect.findTypeHandler(tempValue.getClass());
                typeHandler.setObject(preparedStatement, index, tempValue);
            }
            ++index;
        }
    }

    public <T> T query(Connection con, SQL sql, ResultHandler<T> resultHandler) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1003, 1007);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            this.jdbcContext.dialect().beforeExecuteQuery(preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            T t = resultHandler.apply(resultSet, this.jdbcContext.dialect());
            return t;
        }
    }

    public <T> T query(SQL sql, ResultHandler<T> resultHandler) {
        return (T)ScxExceptionHelper.wrap(() -> {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return this.query(connection, sql, resultHandler);
            }
            try (Connection con = this.getConnection();){
                Object t = this.query(con, sql, resultHandler);
                return t;
            }
        });
    }

    public long execute(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            preparedStatement.execute();
            long l = preparedStatement.getLargeUpdateCount();
            return l;
        }
    }

    public long execute(SQL sql) {
        return (Long)ScxExceptionHelper.wrap(() -> {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return this.execute(connection, sql);
            }
            try (Connection con = this.getConnection();){
                Long l = this.execute(con, sql);
                return l;
            }
        });
    }

    public UpdateResult update(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            long affectedItemsCount = preparedStatement.executeLargeUpdate();
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public UpdateResult update(SQL sql) {
        return (UpdateResult)ScxExceptionHelper.wrap(() -> {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return this.update(connection, sql);
            }
            try (Connection con = this.getConnection();){
                UpdateResult updateResult = this.update(con, sql);
                return updateResult;
            }
        });
    }

    public UpdateResult updateBatch(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            int affectedItemsCount = preparedStatement.executeLargeBatch().length;
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public UpdateResult updateBatch(SQL sql) {
        return (UpdateResult)ScxExceptionHelper.wrap(() -> {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return this.updateBatch(connection, sql);
            }
            try (Connection con = this.getConnection();){
                UpdateResult updateResult = this.updateBatch(con, sql);
                return updateResult;
            }
        });
    }

    public void autoTransaction(ScxRunnable<?> handler) {
        CompletableFuture promise = new CompletableFuture();
        Thread.ofVirtual().name("scx-auto-transaction-thread-", this.threadNumber.getAndIncrement()).start(() -> {
            try (Connection con = this.getConnection(false);){
                CONNECTION_THREAD_LOCAL.set(con);
                try {
                    handler.run();
                    con.commit();
                    promise.complete(null);
                }
                catch (Exception e) {
                    con.rollback();
                    throw e;
                }
                finally {
                    CONNECTION_THREAD_LOCAL.remove();
                }
            }
            catch (Exception e) {
                promise.completeExceptionally(e);
            }
        });
        ScxExceptionHelper.wrap(() -> (Void)promise.get());
    }

    public <T> T autoTransaction(Callable<T> handler) {
        CompletableFuture promise = new CompletableFuture();
        Thread.ofVirtual().name("scx-auto-transaction-thread-", this.threadNumber.getAndIncrement()).start(() -> {
            try (Connection con = this.getConnection(false);){
                CONNECTION_THREAD_LOCAL.set(con);
                try {
                    Object result = handler.call();
                    con.commit();
                    promise.complete(result);
                }
                catch (Exception e) {
                    con.rollback();
                    throw e;
                }
                finally {
                    CONNECTION_THREAD_LOCAL.remove();
                }
            }
            catch (Exception e) {
                promise.completeExceptionally(e);
            }
        });
        return (T)ScxExceptionHelper.wrap(() -> promise.get());
    }

    private Connection getConnection() throws SQLException {
        return this.getConnection(true);
    }

    private Connection getConnection(boolean autoCommit) throws SQLException {
        Connection con = this.jdbcContext.dataSource().getConnection();
        con.setAutoCommit(autoCommit);
        return con;
    }
}

