/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.meta_data;

import cool.scx.jdbc.mapping.Schema;
import cool.scx.jdbc.meta_data.MetaDataHelper;
import cool.scx.jdbc.meta_data.TableMetaData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class SchemaMetaData
implements Schema {
    private final String catalog;
    private final String name;
    private TableMetaData[] tables;
    private Map<String, TableMetaData> tableMap = new HashMap<String, TableMetaData>();

    public SchemaMetaData(String catalog, String name) {
        this.catalog = catalog;
        this.name = name;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public String name() {
        return this.name;
    }

    public TableMetaData[] tables() {
        return this.tables;
    }

    @Override
    public TableMetaData getTable(String name) {
        return this.tableMap.get(name);
    }

    public SchemaMetaData refreshTables(Connection connection) throws SQLException {
        return this.refreshTables(connection, false);
    }

    public SchemaMetaData refreshTables(Connection connection, boolean deep) throws SQLException {
        this.tables = MetaDataHelper.getTables(connection, this.catalog, this.name, null, null);
        this.tableMap = Arrays.stream(this.tables).collect(Collectors.toMap(TableMetaData::name, c -> c));
        if (deep) {
            for (TableMetaData table : this.tables) {
                table.refreshColumns(connection);
            }
        }
        return this;
    }
}

