/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.standard;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;

public enum StandardDataType {
    TINYINT,
    SMALLINT,
    INT,
    BIGINT,
    FLOAT,
    DOUBLE,
    BOOLEAN,
    DECIMAL,
    DATE,
    TIME,
    DATETIME,
    VARCHAR,
    TEXT,
    LONGTEXT,
    BINARY,
    JSON;

    private static final Map<Class<?>, StandardDataType> TYPES;

    private static Map<Class<?>, StandardDataType> initTypes() {
        HashMap map = new HashMap();
        map.put(Byte.TYPE, TINYINT);
        map.put(Short.TYPE, SMALLINT);
        map.put(Integer.TYPE, INT);
        map.put(Long.TYPE, BIGINT);
        map.put(Float.TYPE, FLOAT);
        map.put(Double.TYPE, DOUBLE);
        map.put(Boolean.TYPE, BOOLEAN);
        map.put(Byte.class, TINYINT);
        map.put(Short.class, SMALLINT);
        map.put(Integer.class, INT);
        map.put(Long.class, BIGINT);
        map.put(Float.class, FLOAT);
        map.put(Double.class, DOUBLE);
        map.put(Boolean.class, BOOLEAN);
        map.put(BigInteger.class, BIGINT);
        map.put(BigDecimal.class, DECIMAL);
        map.put(LocalDate.class, DATE);
        map.put(LocalTime.class, TIME);
        map.put(LocalDateTime.class, DATETIME);
        map.put(OffsetTime.class, TIME);
        map.put(OffsetDateTime.class, DATETIME);
        map.put(ZonedDateTime.class, DATETIME);
        map.put(Duration.class, TIME);
        map.put(Instant.class, DATETIME);
        map.put(String.class, VARCHAR);
        map.put(byte[].class, BINARY);
        map.put(Byte[].class, BINARY);
        return map;
    }

    public static StandardDataType getByJavaType(Class<?> javaType) {
        return TYPES.get(javaType);
    }

    static {
        TYPES = StandardDataType.initTypes();
    }
}

