/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler.bean_builder;

import cool.scx.common.util.reflect.ConstructorUtils;
import cool.scx.jdbc.result_handler.bean_builder.BeanBuilder;
import cool.scx.jdbc.result_handler.bean_builder.FieldSetter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.function.Function;

final class RecordBeanBuilder<T>
extends BeanBuilder<T> {
    private final Constructor<T> constructor;
    private final FieldSetter[] fieldSetters;

    public RecordBeanBuilder(Class<T> type, Function<Field, String> columnNameMapping) {
        this.constructor = ConstructorUtils.findRecordConstructor(type);
        this.constructor.setAccessible(true);
        this.fieldSetters = RecordBeanBuilder.sortFieldSetters(this.constructor.getParameters(), FieldSetter.ofArray(type, columnNameMapping));
    }

    public RecordBeanBuilder(Class<T> type) {
        this(type, Field::getName);
    }

    private static FieldSetter[] sortFieldSetters(Parameter[] parameters, FieldSetter[] fieldSetters) {
        HashMap<String, FieldSetter> map = new HashMap<String, FieldSetter>();
        for (FieldSetter fieldSetter : fieldSetters) {
            map.put(fieldSetter.javaField().getName(), fieldSetter);
        }
        FieldSetter[] temp = new FieldSetter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            temp[i] = (FieldSetter)map.get(parameters[i].getName());
        }
        return temp;
    }

    @Override
    public T createBean(ResultSet rs, int[] indexInfo) throws SQLException {
        Object[] objs = new Object[this.fieldSetters.length];
        for (int i = 0; i < this.fieldSetters.length; ++i) {
            objs[i] = indexInfo[i] != -1 ? this.fieldSetters[i].typeHandler().getObject(rs, indexInfo[i]) : this.fieldSetters[i].typeHandler().getDefaultValue();
        }
        return this.newInstance(objs);
    }

    @Override
    public FieldSetter[] fieldSetters() {
        return this.fieldSetters;
    }

    private T newInstance(Object ... objs) {
        try {
            return this.constructor.newInstance(objs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

