/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.type_handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import cool.scx.common.util.ObjectUtils;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ObjectTypeHandler
implements TypeHandler<Object> {
    private static final System.Logger logger = System.getLogger(ObjectTypeHandler.class.getName());
    private static final ObjectMapper objectMapper = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE});
    private final JavaType javaType;

    public ObjectTypeHandler(Type type) {
        this.javaType = ObjectUtils.constructType((Type)type);
    }

    @Override
    public void setObject(PreparedStatement ps, int i, Object parameter) throws SQLException {
        try {
            String json = objectMapper.writeValueAsString(parameter);
            ps.setString(i, json);
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, "\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", (Throwable)e);
            ps.setNull(i, 0);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        String json = rs.getString(index);
        if (json == null) {
            return null;
        }
        try {
            return objectMapper.readValue(json, this.javaType);
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, "\u53cd\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", (Throwable)e);
            return null;
        }
    }
}

