/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler.bean_builder;

import cool.scx.common.util.reflect.ConstructorUtils;
import cool.scx.jdbc.result_handler.bean_builder.BeanBuilder;
import cool.scx.jdbc.result_handler.bean_builder.FieldSetter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;

final class NormalBeanBuilder<T>
extends BeanBuilder<T> {
    private final Constructor<T> constructor;
    private final FieldSetter[] fieldSetters;

    public NormalBeanBuilder(Class<T> type, Function<Field, String> columnNameMapping) {
        this.constructor = ConstructorUtils.findNoArgsConstructor(type);
        this.constructor.setAccessible(true);
        this.fieldSetters = FieldSetter.ofArray(type, columnNameMapping);
    }

    public NormalBeanBuilder(Class<T> type) {
        this(type, Field::getName);
    }

    @Override
    public T createBean(ResultSet rs, int[] indexInfo) throws SQLException {
        T t = this.newInstance();
        for (int i = 0; i < this.fieldSetters.length; ++i) {
            Object o;
            if (indexInfo[i] == -1 || (o = this.fieldSetters[i].typeHandler().getObject(rs, indexInfo[i])) == null) continue;
            try {
                this.fieldSetters[i].fieldInfo().set(t, o);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return t;
    }

    @Override
    public FieldSetter[] fieldSetters() {
        return this.fieldSetters;
    }

    private T newInstance() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

