/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler.bean_builder;

import cool.scx.common.util.reflect.ClassInfo;
import cool.scx.common.util.reflect.FieldInfo;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.lang.reflect.Field;
import java.util.function.Function;

final class FieldSetter {
    private final FieldInfo fieldInfo;
    private final String columnName;
    private TypeHandler<?> typeHandler;

    FieldSetter(FieldInfo fieldInfo, String columnName) {
        this.fieldInfo = fieldInfo;
        this.columnName = columnName;
        this.typeHandler = null;
    }

    static FieldSetter of(FieldInfo field, Function<Field, String> columnNameMapping) {
        field.setAccessible(true);
        String columnName = columnNameMapping.apply(field._field());
        if (columnName == null) {
            columnName = field.name();
        }
        return new FieldSetter(field, columnName);
    }

    static FieldSetter[] ofArray(Class<?> type, Function<Field, String> columnNameMapping) {
        FieldInfo[] fields = new ClassInfo(type).fields();
        FieldSetter[] fieldSetters = new FieldSetter[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldSetters[i] = FieldSetter.of(fields[i], columnNameMapping);
        }
        return fieldSetters;
    }

    public void bindTypeHandler(TypeHandler<Object> typeHandler) {
        this.typeHandler = typeHandler;
    }

    public FieldInfo fieldInfo() {
        return this.fieldInfo;
    }

    public String columnName() {
        return this.columnName;
    }

    public TypeHandler<?> typeHandler() {
        return this.typeHandler;
    }
}

