/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.type_handler;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.util.reflect.ClassUtils;
import cool.scx.jdbc.type_handler.BlobInputStreamTypeHandler;
import cool.scx.jdbc.type_handler.ByteArrayTypeHandler;
import cool.scx.jdbc.type_handler.ByteObjectArrayTypeHandler;
import cool.scx.jdbc.type_handler.ClobReaderTypeHandler;
import cool.scx.jdbc.type_handler.EnumTypeHandler;
import cool.scx.jdbc.type_handler.ObjectTypeHandler;
import cool.scx.jdbc.type_handler.StringTypeHandler;
import cool.scx.jdbc.type_handler.TypeHandler;
import cool.scx.jdbc.type_handler.math.BigDecimalTypeHandler;
import cool.scx.jdbc.type_handler.math.BigIntegerTypeHandler;
import cool.scx.jdbc.type_handler.primitive.BooleanTypeHandler;
import cool.scx.jdbc.type_handler.primitive.ByteTypeHandler;
import cool.scx.jdbc.type_handler.primitive.CharacterTypeHandler;
import cool.scx.jdbc.type_handler.primitive.DoubleTypeHandler;
import cool.scx.jdbc.type_handler.primitive.FloatTypeHandler;
import cool.scx.jdbc.type_handler.primitive.IntegerTypeHandler;
import cool.scx.jdbc.type_handler.primitive.LongTypeHandler;
import cool.scx.jdbc.type_handler.primitive.ShortTypeHandler;
import cool.scx.jdbc.type_handler.time.DateTypeHandler;
import cool.scx.jdbc.type_handler.time.DurationTypeHandler;
import cool.scx.jdbc.type_handler.time.InstantTypeHandler;
import cool.scx.jdbc.type_handler.time.LocalDateTimeTypeHandler;
import cool.scx.jdbc.type_handler.time.LocalDateTypeHandler;
import cool.scx.jdbc.type_handler.time.LocalTimeTypeHandler;
import cool.scx.jdbc.type_handler.time.MonthTypeHandler;
import cool.scx.jdbc.type_handler.time.OffsetDateTimeTypeHandler;
import cool.scx.jdbc.type_handler.time.OffsetTimeTypeHandler;
import cool.scx.jdbc.type_handler.time.YearMonthTypeHandler;
import cool.scx.jdbc.type_handler.time.YearTypeHandler;
import cool.scx.jdbc.type_handler.time.ZonedDateTimeTypeHandler;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeHandlerSelector {
    private final Map<Type, TypeHandler<?>> TYPE_HANDLER_MAP = new ConcurrentHashMap();

    public TypeHandlerSelector() {
        this.registerTypeHandler(Boolean.TYPE, new BooleanTypeHandler(true));
        this.registerTypeHandler(Character.TYPE, new CharacterTypeHandler(true));
        this.registerTypeHandler(Byte.TYPE, new ByteTypeHandler(true));
        this.registerTypeHandler(Short.TYPE, new ShortTypeHandler(true));
        this.registerTypeHandler(Integer.TYPE, new IntegerTypeHandler(true));
        this.registerTypeHandler(Long.TYPE, new LongTypeHandler(true));
        this.registerTypeHandler(Float.TYPE, new FloatTypeHandler(true));
        this.registerTypeHandler(Double.TYPE, new DoubleTypeHandler(true));
        this.registerTypeHandler(Boolean.class, new BooleanTypeHandler(false));
        this.registerTypeHandler(Character.class, new CharacterTypeHandler(false));
        this.registerTypeHandler(Byte.class, new ByteTypeHandler(false));
        this.registerTypeHandler(Short.class, new ShortTypeHandler(false));
        this.registerTypeHandler(Integer.class, new IntegerTypeHandler(false));
        this.registerTypeHandler(Long.class, new LongTypeHandler(false));
        this.registerTypeHandler(Float.class, new FloatTypeHandler(false));
        this.registerTypeHandler(Double.class, new DoubleTypeHandler(false));
        this.registerTypeHandler(String.class, new StringTypeHandler());
        this.registerTypeHandler(Byte[].class, new ByteObjectArrayTypeHandler());
        this.registerTypeHandler(byte[].class, new ByteArrayTypeHandler());
        this.registerTypeHandler(BigInteger.class, new BigIntegerTypeHandler());
        this.registerTypeHandler(BigDecimal.class, new BigDecimalTypeHandler());
        this.registerTypeHandler(LocalDateTime.class, new LocalDateTimeTypeHandler());
        this.registerTypeHandler(LocalDate.class, new LocalDateTypeHandler());
        this.registerTypeHandler(LocalTime.class, new LocalTimeTypeHandler());
        this.registerTypeHandler(OffsetDateTime.class, new OffsetDateTimeTypeHandler());
        this.registerTypeHandler(OffsetTime.class, new OffsetTimeTypeHandler());
        this.registerTypeHandler(ZonedDateTime.class, new ZonedDateTimeTypeHandler());
        this.registerTypeHandler(Month.class, new MonthTypeHandler());
        this.registerTypeHandler(Year.class, new YearTypeHandler());
        this.registerTypeHandler(YearMonth.class, new YearMonthTypeHandler());
        this.registerTypeHandler(Date.class, new DateTypeHandler());
        this.registerTypeHandler(Instant.class, new InstantTypeHandler());
        this.registerTypeHandler(Duration.class, new DurationTypeHandler());
        this.registerTypeHandler(InputStream.class, new BlobInputStreamTypeHandler());
        this.registerTypeHandler(Reader.class, new ClobReaderTypeHandler());
    }

    public <T> void registerTypeHandler(Class<T> type, TypeHandler<T> typeHandler) {
        this.TYPE_HANDLER_MAP.put(type, typeHandler);
    }

    public <T> TypeHandler<T> findTypeHandler(Type type) {
        return this.TYPE_HANDLER_MAP.computeIfAbsent(type, this::createTypeHandler);
    }

    private TypeHandler<?> createTypeHandler(Type type) {
        JavaType javaType;
        TypeHandler<?> c;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            TypeHandler<?> c2 = this.createTypeHandler0(clazz);
            if (c2 != null) {
                return c2;
            }
        } else if (type instanceof JavaType && (c = this.createTypeHandler0((javaType = (JavaType)type).getRawClass())) != null) {
            return c;
        }
        return new ObjectTypeHandler(type);
    }

    private <E extends Enum<E>> TypeHandler<?> createTypeHandler0(Class<?> clazz) {
        if (ClassUtils.isEnum(clazz)) {
            Class<?> enumClass = clazz.isAnonymousClass() ? clazz.getSuperclass() : clazz;
            return new EnumTypeHandler(enumClass);
        }
        for (Map.Entry<Type, TypeHandler<?>> entry : this.TYPE_HANDLER_MAP.entrySet()) {
            Class c;
            Type type = entry.getKey();
            if (!(type instanceof Class) || !(c = (Class)type).isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }
}

