/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.dialect;

import cool.scx.common.standard.JDBCType;
import cool.scx.common.util.StringUtils;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.DataType;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.mapping.type.TypeDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public interface DDLBuilder {
    default public String getCreateTableDDL(Table table) {
        StringBuilder s = new StringBuilder();
        s.append("CREATE TABLE ");
        if (StringUtils.notEmpty((String)table.schema())) {
            s.append(table.schema()).append(".");
        }
        s.append("`").append(table.name()).append("`").append("\n");
        s.append("(\n");
        String createDefinitionStr = this.getCreateDefinition(table).stream().map(c -> "    " + c).collect(Collectors.joining(",\n"));
        s.append(createDefinitionStr);
        s.append("\n);");
        return s.toString();
    }

    default public List<String> getCreateDefinition(Table table) {
        ArrayList<String> createDefinitions = new ArrayList<String>();
        createDefinitions.addAll(this.getColumnDefinitions(table.columns()));
        createDefinitions.addAll(this.getTableConstraint(table));
        return createDefinitions;
    }

    default public List<String> getColumnDefinitions(Column[] columns) {
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns) {
            list.add(this.getColumnDefinition(column));
        }
        return list;
    }

    default public List<String> getTableConstraint(Table table) {
        return new ArrayList<String>();
    }

    default public String getColumnDefinition(Column column) {
        StringBuilder s = new StringBuilder();
        s.append("`").append(column.name()).append("`").append(" ");
        String dataTypeDefinition = this.getDataTypeDefinition(column);
        if (dataTypeDefinition != null) {
            s.append(dataTypeDefinition).append(" ");
        }
        String columnConstraintStr = String.join((CharSequence)" ", this.getColumnConstraint(column));
        s.append(columnConstraintStr);
        return s.toString();
    }

    default public String getDataTypeDefinition(Column column) {
        if (column.dataType() != null) {
            TypeDataType m;
            DataType _dataType = column.dataType();
            String _name = _dataType.name();
            if (_dataType instanceof TypeDataType && (m = (TypeDataType)_dataType).jdbcType() != null) {
                _name = this.getDataTypeNameByJDBCType(m.jdbcType());
            }
            return this.getDataTypeDefinitionByName(_name, _dataType.length());
        }
        return this.defaultDateType();
    }

    default public List<String> getColumnConstraint(Column column) {
        return new ArrayList<String>();
    }

    public String getDataTypeNameByJDBCType(JDBCType var1);

    default public String getDataTypeDefinitionByName(String dataType, Integer length) {
        return length != null ? dataType + "(" + length + ")" : dataType;
    }

    default public String defaultDateType() {
        return null;
    }

    default public String getAlertTableDDL(Column[] needAdds, Table tableInfo) {
        StringBuilder s = new StringBuilder();
        s.append("ALTER TABLE ");
        if (StringUtils.notEmpty((String)tableInfo.schema())) {
            s.append(tableInfo.schema()).append(".");
        }
        s.append("`").append(tableInfo.name()).append("`").append("\n");
        String columnDefinitionStr = this.getColumnDefinitions(needAdds).stream().map(c -> "    ADD COLUMN " + c).collect(Collectors.joining(",\n"));
        s.append(columnDefinitionStr);
        s.append("\n;");
        return s.toString();
    }
}

