/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.type_handler.time;

import cool.scx.common.util.ScxDateTimeFormatter;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.LocalDate;

public class LocalDateTypeHandler
implements TypeHandler<LocalDate> {
    @Override
    public void setObject(PreparedStatement ps, int i, LocalDate parameter) throws SQLException {
        try {
            ps.setObject(i, parameter);
        }
        catch (SQLFeatureNotSupportedException e) {
            ps.setString(i, ScxDateTimeFormatter.yyyy_MM_dd.format(parameter));
        }
    }

    @Override
    public LocalDate getObject(ResultSet rs, int index) throws SQLException {
        try {
            return rs.getObject(index, LocalDate.class);
        }
        catch (SQLFeatureNotSupportedException e) {
            String str = rs.getString(index);
            return str == null ? null : ScxDateTimeFormatter.yyyy_MM_dd.parse((CharSequence)str, LocalDate::from);
        }
    }
}

